%define _unpackaged_files_terminate_build 1
%define oname Fabric
%define pypi_name fabric
%define mod_name %pypi_name

%def_with check

Name: python3-module-%oname
Version: 3.2.2
Release: alt1
Summary: High level SSH command execution
License: BSD-2-Clause
Group: Development/Python3
Url: https://pypi.org/project/fabric/
Vcs: https://github.com/fabric/fabric
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
Conflicts: python-module-%oname

%pyproject_runtimedeps_metadata
# mapping from PyPI name
Provides: python3-module-%{pep503_name %pypi_name} = %EVR
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
BuildRequires: /dev/pts
%add_pyproject_deps_check_filter codecov alabaster
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif

%description
Fabric is a high level Python (2.7, 3.4+) library designed to execute shell
commands remotely over SSH, yielding useful Python objects in return. It builds
on top of Invoke (subprocess command execution and command-line features) and
Paramiko (SSH protocol implementation), extending their APIs to complement one
another and provide additional functionality.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name

%description tests
Fabric is a high level Python (2.7, 3.4+) library designed to execute shell
commands remotely over SSH, yielding useful Python objects in return. It builds
on top of Invoke (subprocess command execution and command-line features) and
Paramiko (SSH protocol implementation), extending their APIs to complement one
another and provide additional functionality.

This package contains tests for %oname.

%prep
%setup
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_pipreqfile dev-requirements.txt
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run -- inv test

%files
%doc README.rst
%_bindir/fab
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%exclude %python3_sitelibdir/%mod_name/testing

%files tests
%python3_sitelibdir/%mod_name/testing/

%changelog
