%def_disable snapshot

%define modname dbusmock
%define pypi_name python_%modname
%def_disable check

Name: python3-module-dbusmock
Version: 0.34.3
Release: alt1

Summary: mock D-Bus objects for tests
License: LGPL-3.0-or-later
Group: Development/Python3
Url: https://pypi.python.org/pypi/%pypi_name

Vcs: https://github.com/martinpitt/python-dbusmock.git

%if_disabled snapshot
#Source: %url/releases/download/%version/%pypi_name-%version.tar.gz
Source: https://pypi.io/packages/source/p/%pypi_name/%pypi_name-%version.tar.gz
%else
Source: %pypi_name-%version.tar
%endif

BuildArch: noarch
Requires: dbus

BuildRequires(pre): rpm-build-python3 rpm-build-gir
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-dbus
%if_enabled check
BuildRequires: /proc dbus-tools-gui %_bindir/notify-send %_bindir/nmcli upower
BuildRequires: /dev/pts bluez /etc/os-release
BuildRequires: polkit iio-sensor-proxy notification-daemon
BuildRequires: python3(pytest)
BuildRequires: python3-module-dbus-gobject python3-module-pycodestyle
BuildRequires: python3-module-pyflakes python3-module-importlib-metadata
BuildRequires: python3-module-mypy
%endif

%description
With this program/Python library you can easily create mock objects on
D-Bus. This is useful for writing tests for software which talks to D-Bus
services such as upower, systemd, logind, gnome-session or others,
and it is hard (or impossible without root privileges) to set the state
of the real services to what you expect in your tests.

See %_docdir/%name-%version/README.rst for more information.

%prep
%setup -n %pypi_name-%version

%build
%pyproject_build

%install
%pyproject_install

%check
python3 -m unittest

%files
%python3_sitelibdir_noarch/%modname/
%python3_sitelibdir_noarch/%{pyproject_distinfo %pypi_name}
%doc NEWS PKG-INFO README*

%changelog
