%define oname qrcode

%def_with check

Name: python3-module-%oname
Version: 7.4.2
Release: alt4

Summary: Python module to generate QR Codes

License: BSD-3-Clause
Group: Development/Python3
URL: https://pypi.org/project/qrcode
VCS: https://github.com/lincolnloop/python-qrcode

Source: %name-%version.tar
Patch: 1009adc1d19529c49e2f20b8ebc759e30060a5b2.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
Buildrequires: python3-module-setuptools
Buildrequires: python3-module-wheel

%if_with check
Buildrequires: python3-module-pytest
Buildrequires: python3-module-Pillow
Buildrequires: python3-module-typing_extensions
Buildrequires: python3-module-pypng
%endif

Conflicts: python-module-%oname
Obsoletes: python-module-%oname

%description
This module uses image libraries, Python Imaging Library (PIL) by default,
to generate QR Codes.

%prep
%setup
%patch -p1

%build
%pyproject_build

%install
%pyproject_install

%check
# test_bad_factory broken
# https://github.com/lincolnloop/python-qrcode/issues/361
%pyproject_run_pytest -k'not test_script'

%files
%doc README.rst LICENSE CHANGES.rst
%_bindir/qr
%_man1dir/*
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
