%define _unpackaged_files_terminate_build 1

%define pypi_name statsmodels
%define mod_name %pypi_name

# quite a few tests fail on armh. disable it for now
%ifnarch armh
%def_with check
%else
%def_without check
%endif

Name: python3-module-%pypi_name
Version: 0.14.2
Release: alt1
Epoch: 1
Summary: Statistical computations and models for Python
License: BSD-3-Clause
Group: Development/Python3
Url: https://pypi.org/project/statsmodels/
Vcs: https://github.com/statsmodels/statsmodels
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
%add_python3_req_skip models
# rename scikits.statsmodels => statsmodels
Provides: python3-module-scikits.statsmodels = %EVR
Obsoletes: python3-module-scikits.statsmodels <= 0.11.1-alt2.1

BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
BuildRequires: libnumpy-py3-devel
%if_with check
%pyproject_builddeps_metadata_extra develop
# compat.pandas => pandas.testing
BuildRequires: python3-module-pandas-tests
BuildRequires: python3-module-numpy-testing
%endif

%description
Statsmodels is a Python package that provides a complement to scipy for
statistical computations including descriptive statistics and estimation
and inference for statistical models.

%prep
%setup
%autopatch -p1
%pyproject_scm_init
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%add_optflags -fno-strict-aliasing
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run -- bash -s <<-'ENDUNITTEST'
set -eu
mkdir empty
cd empty
python3 -c 'import statsmodels; statsmodels.test(["--skip-examples", "--only-smoke", "--skip-slow", "-n", "auto"], exit=True)'
ENDUNITTEST

%files
%doc LICENSE.txt
%doc README*.*
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
