%define oname stuf

%def_disable check

Name: python3-module-%oname
Version: 0.9.16
Release: alt3.git20150404.1
Summary: Normal, default, ordered, chained, restricted, counter, and frozen dictionaries
License: BSD
Group: Development/Python3
BuildArch: noarch
Url: https://pypi.python.org/pypi/stuf

# https://bitbucket.org/lcrees/stuf.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-parse
BuildRequires: python3-module-pytest python3-module-coverage

%py3_provides %oname
%py3_requires parse

%add_python3_req_skip stuf.six.moves

%description
A collection of Python dictionary types that support attribute-style
access. Includes defaultdict, OrderedDict, restricted, ChainMap,
Counter, and frozen implementations plus miscellaneous utilities for
writing Python software.

%prep
%setup

%build
%python3_build

%install
%python3_install

%check
python3 setup.py test -v
nosetests3 -vv --with-coverage --cover-package=%oname

%files
%doc *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/tests

%changelog
