%define _unpackaged_files_terminate_build 1
%define pypi_name twine
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 6.1.0
Release: alt1
Summary: Collection of utilities for publishing packages on PyPI
License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/twine/
Vcs: https://github.com/pypa/twine
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch
%pyproject_runtimedeps_metadata_extra keyring
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata_extra keyring
%pyproject_builddeps_check
%endif

%description
Twine is a utility for interacting with PyPI.
It provides build system independent uploads of source and binary distribution
artifacts for both new and existing projects.

%prep
%setup
%autopatch -p1
%pyproject_scm_init
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_tox tox.ini testenv
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
# some tests rely on colors in output
# (see tests/test_main.py::test_exception_handling)
export TERM=xterm
%pyproject_run_pytest -ra

%files
%doc README.*
%_bindir/*
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
