Name: rapid-photo-downloader
Version: 0.9.36
Release: alt1

%define xdg_name net.damonlynch.rapid_photo_downloader

Summary: Download photos and videos from cameras, memory cards and Portable Storage Devices
License: GPLv3+
Group: Graphics
Url: http://www.damonlynch.net/rapid/

Vcs: https://github.com/damonlynch/rapid-photo-downloader.git
Source: https://launchpad.net/rapid/pyqt/%version/+download/%name-%version.tar.gz

BuildArch: noarch

%add_typelib_req_skiplist typelib(Unity)

Requires: python3-module-PyQt5 >= 5.15.6 libqt5-svg
Requires: python3-module-zmq >= 16.0.2
Requires: python3-module-easygui >= 0.98.1
Requires: python3-module-pymediainfo >= 2.2.0
Requires: python3-module-pyprind
Requires: python3-module-colorlog
Requires: python3-module-pyxdg
Requires: gphoto2 exiv2 perl-Image-ExifTool >= 10.87
Requires: gst-plugins-good1.0 gst-libav
# since 0.9.27
Requires: showinfilemanager >= 1.1.2
Requires: libimobiledevice ifuse fuse

BuildRequires(pre): rpm-build-gir rpm-build-python3
BuildRequires: intltool perl-podlators
BuildRequires: python3-devel python3(wheel) python3(setuptools)

%description
Rapid Photo Downloader imports photos and videos from cameras, phones,
memory cards and other devices at high speed. It can be configured to
rename photos and videos with meaningful filenames you specify. It can
also back up photos and videos as they are downloaded. It downloads from
and backs up to multiple devices simultaneously.

%prep
%setup
sed -i "s|'share\/solid\/actions'|'share/apps/solid/actions'|
        s|\(>=3.6\)\.\*|\1|" setup.py

%build
%pyproject_build

%install
%pyproject_install
# install translations
mkdir -p %buildroot%_datadir/locale
cp -r build/mo/* %buildroot%_datadir/locale
%find_lang %name

%files -f %name.lang
%_bindir/%name
%python3_sitelibdir/*
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/*/*
%_datadir/metainfo/%xdg_name.metainfo.xml
%_man1dir/%name.1.*
%_datadir/solid/actions/%xdg_name.desktop
%doc README* RELEASE_NOTES* CHANGES*

%changelog
