%def_disable snapshot
%define _libexecdir %_prefix/libexec

%define _name smile
%define ver_major 2.10
%define rdn_name it.mijorus.smile

# <screenshot> height too large
%def_disable check

Name: %_name
Version: %ver_major.1
Release: alt1

Summary: An emoji picker
Group: Graphical desktop/GNOME
License: GPL-3.0-or-later
Url: https://github.com/mijorus/smile

Vcs: https://github.com/mijorus/smile.git

%if_enabled snapshot
Source: %_name-%version.tar
%else
Source: %url/archive/%version/%_name-%version.tar.gz
%endif

BuildArch: noarch
%add_python3_path %_datadir/%_name

%define adw_ver 1.6

Requires: dconf font(notocoloremoji)
Requires: typelib(Adw) = 1
Requires: /usr/bin/wl-copy

BuildRequires(pre): rpm-macros-meson rpm-build-gir rpm-build-python3
BuildRequires: meson
BuildRequires: libgio-devel
BuildRequires: /usr/bin/glib-compile-resources /usr/bin/gtk4-update-icon-cache
%{?_enable_check:BuildRequires: /usr/bin/appstream-util desktop-file-utils /usr/bin/glib-compile-schemas}

%description
An emoji picker for linux, with custom tags support and localization.

%prep
%setup -n %_name-%version

%build
%meson
%meson_build

%install
%meson_install
ln -sf ../../fonts/ttf/google-noto-emoji/NotoColorEmoji.ttf \
%buildroot%_datadir/%name/assets/NotoColorEmoji.ttf

%find_lang %name

%check
%__meson_test -v

%files -f %name.lang
%_bindir/%_name
%_desktopdir/%rdn_name.desktop
%_datadir/%_name/
%_datadir/glib-2.0/schemas/%rdn_name.gschema.xml
%_iconsdir/hicolor/*/*/*.svg
%_datadir/appdata/%rdn_name.appdata.xml
%doc README*

%changelog
