%define _libexecdir %_prefix/libexec
%define api_ver 5.5
%define plugin_abi_ver 0

#monitor device suspending and resuming
%def_disable upower
# NetworkManager support
%def_enable nm
%def_disable check

Name: telepathy-mission-control
Version: 5.16.6
Release: alt1

Summary: Telepathy mission control plugin library
License: LGPL-2.1
Group: System/Libraries
Url: http://mission-control.sourceforge.net/

Source: http://telepathy.freedesktop.org/releases/%name/%name-%version.tar.gz

Requires: dconf

BuildRequires(pre): rpm-build-python3
BuildRequires: gtk-doc libgio-devel >= 2.46.0 libdbus-glib-devel libtelepathy-glib-devel >= 0.22.0
%{?_enable_upower:BuildRequires: libupower-devel < 0.99}
%{?_enable_nm:BuildRequires: libnm-devel}

%if_enabled check
BuildRequires: /proc python3-module-twisted-words python3-module-twisted-core
BuildRequires: python3-module-dbus telepathy-logger dbus-tools-gui
%endif

%description
Mission Control, or MC, is a Telepathy component providing a way for
"end-user" applications to abstract some of the details of connection
managers, to provide a simple way to manipulate a bunch of connection
managers at once, and to remove the need to have in each program the
account definitions and credentials.

%package -n lib%name
Summary: Telepathy mission control plugin library
Group: System/Libraries
Obsoletes: %name
Provides: %name = %version-%release

%description -n lib%name
Mission Control, or MC, is a Telepathy component providing a way for
"end-user" applications to abstract some of the details of connection
managers, to provide a simple way to manipulate a bunch of connection
managers at once, and to remove the need to have in each program the
account definitions and credentials.

%package -n lib%name-devel
Summary: Development libraries and header files for %name
Group: Development/C
Requires: lib%name = %version-%release
Obsoletes: %name-devel
Provides: %name-devel = %version-%release

%description -n lib%name-devel
Development libraries and header files for %name.

%prep
%setup

%build
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
export CFLAGS="$CFLAGS `pkg-config --cflags glib-2.0` `pkg-config --cflags dbus-glib-1`"
%configure \
	--disable-static \
	--disable-schemas-compile \
	PYTHON=%__python3

%make_build

%install
%makeinstall_std
# plugin dir
mkdir %buildroot%_libdir/mission-control-plugins.%plugin_abi_ver

%check
%make check

%files -n lib%name
%_bindir/*
%_libdir/libmission-control-plugins.so.*
%_libexecdir/mission-control-5
%dir %_libdir/mission-control-plugins.%plugin_abi_ver
%_datadir/dbus-1/services/*.service
%_datadir/glib-2.0/schemas/im.telepathy.MissionControl.FromEmpathy.gschema.xml
%_man1dir/*
%_man8dir/*
%doc AUTHORS ChangeLog

%files -n lib%name-devel
%_libdir/libmission-control-plugins.so
%_includedir/mission-control-%api_ver/
%_pkgconfigdir/*.pc
%_datadir/gtk-doc/html/*

%changelog
