
%define _unpackaged_files_terminate_build 1
%def_enable check

Name:    yq
Version: 3.4.3
Release: alt1
Summary: Command-line YAML, XML and TOML processor
License: Apache-2.0
Group:   Other
URL:     https://github.com/kislyuk/yq

Packager: Ivan A. Melnikov <iv@altlinux.org>

BuildRequires: rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3(pip) python3(setuptools_scm)
%if_enabled check
BuildRequires: jq
BuildRequires: python3-module-xmltodict >= 0.11.0
BuildRequires: python3-module-tomlkit >= 0.11.6
BuildRequires: python3(argcomplete)
BuildRequires: python3(yaml)
BuildRequires: /proc
%endif

BuildArch: noarch

Source:  %name-%version.tar

Requires: jq
Requires: python3-module-xmltodict >= 0.11.0
Requires: python3-module-tomlkit >= 0.11.6

%description
yq is a command-line YAML, XML and TOML processor.
It is a jq wrapper for YAML, XML and TOML documents.

%prep
%setup -n %name-%version

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python3_build

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python3_install

%check
%__python3 ./test/test.py -v

%files
%doc README.rst
%_bindir/*
%python3_sitelibdir/%name/
%python3_sitelibdir/*.egg-info

%changelog
