# git describe mainline-0-%version
%define git_descr mainline-636-14434-g537296095ab

%define sirit_commit ab75463999f4f3291976b079d42d52ee91eebf3f
%define tzdb_to_nx_commit 97929690234f2b4add36b33657fe3fe09bd57dfd

Name: yuzu
Version: 1734
Release: alt7

Summary: Nintendo Switch emulator/debugger
License: GPLv3+
Group: Emulators

Url: https://%name-emu.org/
Vcs: https://github.com/%name-emu/%name-mainline
Packager: Nazarov Denis <nenderus@altlinux.org>

ExcludeArch: %ix86

# https://github.com/%name-emu/%name-mainline/archive/mainline-0-%version/%name-mainline-mainline-0-%version.tar.gz
Source0: %name-mainline-mainline-0-%version.tar
# https://github.com/ReinUsesLisp/sirit/archive/%sirit_commit/sirit-%sirit_commit.tar.gz
Source1: sirit-%sirit_commit.tar
# https://github.com/lat9nq/tzdb_to_nx/archive/%tzdb_to_nx_commit/tzdb_to_nx-%tzdb_to_nx_commit.tar.gz
Source2: tzdb_to_nx-%tzdb_to_nx_commit.tar

Patch0: %name-cpp-jwt-version-alt.patch
Patch1: %name-xbyak-version-alt.patch
Patch2: %name-fmt11-alt.patch
Patch3: %name-dynarmic-6.7-debian.patch
Patch4: %name-llvm-version-debian.patch
Patch5: %name-httplib-version-alt.patch
Patch6: %name-mcl-find-alt.patch
Patch7: %name-simpleini-system-alt.patch
Patch8: %name-mbedtls-system-debian.patch

BuildRequires: /proc
BuildRequires: alt-os-release
BuildRequires: boost-asio-devel
BuildRequires: boost-filesystem-devel
BuildRequires: catch-devel
BuildRequires: clang
BuildRequires: clang-tools
BuildRequires: ctest
BuildRequires: git-core
BuildRequires: glslang
BuildRequires: libSDL2-devel
BuildRequires: libVulkanUtilityLibraries-devel
BuildRequires: libavcodec-devel
BuildRequires: libavfilter-devel
BuildRequires: libbrotli-devel
BuildRequires: libcpp-httplib-devel
BuildRequires: libcpp-jwt-devel
BuildRequires: libcubeb-devel
BuildRequires: libdynarmic-devel
BuildRequires: libedit-devel
BuildRequires: libenet-devel
BuildRequires: libffi-devel
BuildRequires: libgamemode-devel
BuildRequires: liblz4-devel
BuildRequires: libmbedtls-devel
BuildRequires: libopus-devel
BuildRequires: libsimpleini-devel
BuildRequires: libstb-devel
BuildRequires: libswscale-devel
BuildRequires: libusb-devel
BuildRequires: libvulkan-memory-allocator-devel
BuildRequires: libxml2-devel
BuildRequires: libzstd-devel
BuildRequires: lld
BuildRequires: llvm
BuildRequires: llvm-devel
BuildRequires: nlohmann-json-devel
BuildRequires: python-modules-encodings
BuildRequires: python3-dev
BuildRequires: qt6-tools-devel
BuildRequires: renderdoc-devel
BuildRequires: spirv-headers
BuildRequires: zlib-devel

%description
%name is an open source Nintendo Switch emulator/debugger.

%prep
%setup -n %name-mainline-mainline-0-%version -b 1 -b 2

%autopatch -p1

%__mv -Tf ../sirit-%sirit_commit externals/sirit
%__mv -Tf ../tzdb_to_nx-%tzdb_to_nx_commit externals/nx_tzdb/tzdb_to_nx

# Enforce package versioning in GUI
sed -i \
-e 's|@GIT_BRANCH@|HEAD|g' \
-e 's|@GIT_DESC@|%git_descr|g' \
-e 's|@TITLE_BAR_FORMAT_IDLE@|%name %version|g' \
-e 's|@TITLE_BAR_FORMAT_RUNNING@|%name %version|g' \
src/common/scm_rev.cpp.in

%__rm .gitmodules

%build
sed -i -e 's/-Werror=shadow-uncaptured-local/-Wno-error=shadow-uncaptured-local/' src/CMakeLists.txt
sed -i -e 's/-Werror=conversion/-Wno-error=conversion/' src/input_common/CMakeLists.txt

%add_optflags -Wno-error=conversion -I%_includedir/SimpleIni -DXBYAK_STRICT_CHECK_MEM_REG_SIZE=0

export CC="clang"
export CXX="clang++"
export RANLIB="llvm-ranlib"
export AR="llvm-ar"
export NM="llvm-nm"
export LDFLAGS="-fuse-ld=lld $LDFLAGS"

%cmake \
	-DCMAKE_BUILD_TYPE:STRING=RelWithDebInfo \
	-DENABLE_QT6:BOOL=TRUE \
	-DENABLE_QT_TRANSLATION:BOOL=TRUE \
	-DYUZU_USE_EXTERNAL_SDL2:BOOL=FALSE \
	-DYUZU_USE_EXTERNAL_VULKAN_HEADERS:BOOL=FALSE \
	-DYUZU_USE_EXTERNAL_VULKAN_UTILITY_LIBRARIES:BOOL=FALSE \
	-DYUZU_ENABLE_LTO:BOOL=TRUE \
	-DYUZU_TESTS:BOOL=TRUE \
	-DSIRIT_USE_SYSTEM_SPIRV_HEADERS:BOOL=TRUE \
	-DLLVM_DIR:PATH=$(llvm-config --cmakedir) \
	-DTZDB2NX_ZONEINFO_DIR:PATH=%_datadir/zoneinfo \
	-DTZDB2NX_VERSION:STRING=$(stat -c '%y' /usr/share/zoneinfo/tzdata.zi | sed 's/\(....-..-..\).*/\1/' | tr -dc '[:digit:]') \
	-GNinja \
	-Wno-dev
%cmake_build

%install
%cmake_install

%check
%ctest || :

%files
%doc CONTRIBUTING.md README.md
%_bindir/%name
%_bindir/%name-cmd
%_bindir/%name-room
%_desktopdir/org.%{name}_emu.%name.desktop
%_datadir/metainfo/org.%{name}_emu.%name.metainfo.xml
%_datadir/mime/packages/org.%{name}_emu.%name.xml
%_iconsdir/hicolor/scalable/apps/org.%{name}_emu.%name.svg

%changelog
