%define uversion 20220115

Name: AlephOne
Version: 1.0.2
Release: alt1.2

Summary: 3D first-person shooter game
License: %gpl2plus
Group: Games/Arcade
Url: https://alephone.lhowon.org
# Url git  https://github.com/Aleph-One-Marathon/alephone

# https://github.com/Aleph-One-Marathon/alephone/releases/download/release-20220115/AlephOne-20220115.tar.bz2

Packager: Hihin Ruslan <ruslandh@altlinux.ru>

Source0: %name-%uversion.tar
Source1: %name.desktop
Source2: %name-48x48.png
Source3: alephone-wrapper.sh

#Patch0: %name-1.0.1-gcc8-fix.patch
Patch1: ax_boost_base-loongarch64.patch


BuildRequires(pre): rpm-build-licenses

BuildPreReq: libSDL2-devel libSDL2_image-devel libSDL2_net-devel  boost-program_options-devel
BuildPreReq: libsdl2_sound-devel libSDL2_ttf-devel boost-filesystem-devel


# Automatically added by buildreq on Sat Jul 16 2022
# optimized out: boost-devel boost-devel-headers glibc-kernheaders-generic glibc-kernheaders-x86 libSDL2-devel libglvnd-devel libgpg-error libogg-devel libsasl2-3 libstdc++-devel perl pkg-config python3 python3-base sh4 zlib-devel zziplib
BuildRequires: boost-filesystem-devel gcc-c++ libGLU-devel libSDL2_image-devel libSDL2_net-devel libSDL2_ttf-devel libalsa-devel
BuildRequires: libcurl-devel libmad-devel libminiupnpc-devel libpng-devel libsmpeg-devel libsndfile-devel libspeex-devel libspeexdsp-devel
BuildRequires: libvorbis-devel lua5.3 python3-dev zziplib-devel /usr/bin/python3

BuildRequires: desktop-file-utils

%description
Aleph One is an Open Source 3D first-person shooter game, based on the game
Marathon 2 by Bungie Software. It is set in a Sci-Fi universe dominated by
deviant computer AIs and features a well thought-out plot. Aleph One
supports, but doesn't require, OpenGL for rendering.

Aleph One requires additional data -- shape, sound, and map
information -- in order to run. The easiest way to get this is to go
to http://source.bungie.org/get/, and download one of the scenario zip
files there. Unzip it, and pass the resulting directory as an argument
to alephone. For example:

alephone "~/Marathon Infinity"

%prep
%setup -n %name-%uversion
#patch0 -p2
%patch1 -p1
%ifarch %e2k
sed -i 's,aarch64,&|e2k,' m4/ax_boost_base.m4
%endif


%build
#add_optflags -fpermissive
#configure --bindir=%_gamesbindir --datadir=%_gamesdatadir
#make_build

%autoreconf

%configure \
--enable-dependency-tracking

%make_build

%install
%makeinstall_std
#desktop-file-install --dir %buildroot%_desktopdir %SOURCE1
#install -pD -m644 %SOURCE2 %buildroot%_liconsdir/%name.png
#install -pD -m755 %SOURCE3 %buildroot%_gamesbindir/

%files
%doc AUTHORS COPYING INSTALL.Unix README docs/*.html examples
%_bindir/alephone
#%_datadir/AlephOne/Fonts
%_datadir/AlephOne/MML
%_datadir/AlephOne/Plugins
%_datadir/mime/packages/*.xml

%_iconsdir/hicolor/*/mimetypes/*.png

%_man6dir/*

#doc AUTHORS COPYING  INSTALL.Unix README docs/*.html examples
#dir %_gamesdatadir/%name
#dir %_gamesdatadir/%name/MML
#dir %_gamesdatadir/%name/Themes
#_gamesbindir/*
#_gamesdatadir/%name/Fonts
#_gamesdatadir/%name/MML/*.mml
#_gamesdatadir/%name/Themes/Default
#_liconsdir/%name.png
#_desktopdir/*
#_man6dir/*


%changelog
