
%define _unpackaged_files_terminate_build 1

Name:     Cardinal
Version:  24.04
Release:  alt1

Summary:  Virtual modular synthesizer plugin
License:  GPL-3.0-or-later
Group:    Sound
Url:      https://github.com/DISTRHO/Cardinal

ExclusiveArch: x86_64 aarch64

Source:   %name-%version.tar

Source1: sub-merge.sources.txt
Source2: sub-merge.unpack.sh

# Import sub-merge sources right here
%(cat %SOURCE1)

Patch1:   Cardinal-22.07-alt-lv2-in-lib64.patch
Patch2:   Cardinal-22.11-rebeltech-fix-compilation.patch
Patch3:   Cardinal-22.12-alt-more-system-libs.patch

BuildRequires: gcc-c++ cmake
BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(cairo)
BuildRequires: pkgconfig(dbus-1)
BuildRequires: pkgconfig(fftw3f)
BuildRequires: pkgconfig(fmt)
BuildRequires: pkgconfig(freetype2)
BuildRequires: pkgconfig(gl)
BuildRequires: pkgconfig(jack)
BuildRequires: pkgconfig(jansson)
BuildRequires: pkgconfig(libarchive)
BuildRequires: pkgconfig(liblo)
BuildRequires: pkgconfig(libpulse-simple)
BuildRequires: pkgconfig(lv2)
BuildRequires: pkgconfig(samplerate)
BuildRequires: pkgconfig(sdl2)
BuildRequires: pkgconfig(speexdsp)
BuildRequires: pkgconfig(vulkan)
BuildRequires: pkgconfig(x11)
BuildRequires: pkgconfig(xcursor)
BuildRequires: pkgconfig(xext)
BuildRequires: pkgconfig(xrandr)

Requires: %name-common = %EVR

%description
Cardinal is a free and open-source virtual modular synthesizer
plugin. It is based on the popular VCV Rack but with a focus on
being a fully self-contained plugin version. More specifically,
this is a DPF-based plugin wrapper around VCV Rack, using its code
directly instead of forking the project, with the target of having
a proper, self-contained, fully free and open-source plugin version
of Rack.

Cardinal contains Rack, some 3rd-party modules and a few internal
utilities all in a single binary.

This package provides Cardinal as standalone jack client.


%package -n lv2-Cardinal-plugins
Group:    Sound
Summary:  Virtual modular synthesizer -- LV2 plugin
Requires: %name-common = %EVR

%description -n lv2-Cardinal-plugins
Cardinal is a free and open-source virtual modular synthesizer
plugin. It is based on the popular VCV Rack but with a focus on
being a fully self-contained plugin version. More specifically,
this is a DPF-based plugin wrapper around VCV Rack, using its code
directly instead of forking the project, with the target of having
a proper, self-contained, fully free and open-source plugin version
of Rack.

Cardinal contains Rack, some 3rd-party modules and a few internal
utilities all in a single binary.

This package provides Cardinal as LV2 plugin.


%package common
Group:    Sound
Summary:  Virtual modular synthesizer -- resources
BuildArch: noarch

%description common
Cardinal is a free and open-source virtual modular synthesizer
plugin. It is based on the popular VCV Rack but with a focus on
being a fully self-contained plugin version. More specifically,
this is a DPF-based plugin wrapper around VCV Rack, using its code
directly instead of forking the project, with the target of having
a proper, self-contained, fully free and open-source plugin version
of Rack.

Cardinal contains Rack, some 3rd-party modules and a few internal
utilities all in a single binary.

This package contains common resources for Cardinal.


%prep
%setup

# unpack sub-merged sources
sh "%SOURCE2"

# don't build VST plugin variants
sed -i '/^TARGETS/ s/vst[23]\|clap//g' src/Makefile.cardinal.mk

%autopatch -p0

%build
%make_build \
    NOOPT=true \
    SKIP_STRIPPING=true \
    PREFIX=/usr \
    SYSDEPS=true \
    WITH_LTO=true \
    AR=gcc-ar \
    VERBOSE=1

%install
# standalone
install -Dm755 bin/Cardinal %buildroot%_bindir/Cardinal
install -Dm755 bin/CardinalNative %buildroot%_bindir/CardinalNative

# resources
install -d %buildroot%_datadir/cardinal/
cp -rL bin/Cardinal.lv2/resources/* %buildroot%_datadir/cardinal/

# lv2
for plugin in Cardinal CardinalFX CardinalSynth CardinalMini; do
    src="bin/$plugin.lv2"
    dst="%buildroot%_libdir/lv2/$plugin.lv2"

    install -d "$dst"
    install -m644 "$src"/*.so "$dst"
    install -m644 "$src"/*.ttl "$dst"
done

# docs
install -d %buildroot%_datadir/doc/cardinal/docs
install -m 644 README.md %buildroot%_datadir/doc/cardinal/
install -m 644 docs/*.md docs/*.png %buildroot%_datadir/doc/cardinal/docs/


%files
%_bindir/*

%files -n lv2-Cardinal-plugins
%_libdir/lv2/*

%files common
%_datadir/cardinal
%doc %_datadir/doc/cardinal

%changelog
