Name: GraphicsMagick
Version: 1.3.43
Release: alt1

Summary: Image manipulation and translation utility
License: MIT
Group: Graphics
Url: http://www.graphicsmagick.org

Provides: %name-common = %version-%release
Obsoletes: GraphicsMagick-common

Source: ftp://ftp.graphicsmagick.org/pub/%name/%name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: gcc-c++
BuildRequires: bzlib-devel
BuildRequires: libfreetype-devel
BuildRequires: libheif-devel
BuildRequires: libjasper-devel
BuildRequires: libjbig-devel
BuildRequires: libjpeg-devel
BuildRequires: liblcms2-devel
BuildRequires: libltdl-devel
BuildRequires: liblzma-devel
BuildRequires: libpng-devel
BuildRequires: libtiff-devel
BuildRequires: libwebp-devel
BuildRequires: libxml2-devel
BuildRequires: libzstd-devel
BuildRequires: zlib-devel

%ifarch %e2k
# lcc's openmp implementation is way too old
%def_disable openmp
%else
%def_enable openmp
%endif

%define quantum_depth 16
%define gmpath %_libdir/%name-%version
%define modulepath %gmpath/modules-Q%quantum_depth

%package doc
Summary:  Documentation for Graphicsmagick
Group: Documentation
BuildArch: noarch

%package -n libGraphicsMagick
Summary: GraphicsMagick shared libraries
Group: System/Libraries

%package -n libGraphicsMagick-c++
Summary: C++ bindings for GraphicsMagick
Group: System/Libraries

%package -n libGraphicsMagick-devel
Summary: Header files for GraphicsMagick app development
Group: Development/C

%package -n libGraphicsMagick-c++-devel
Summary: C++ bindings for GraphicsMagick
Group: Development/C++

%description
GraphicsMagick provides a powerful image manipulation and translation
utility. It is capable of displaying still images and animations using
the X Window system, provides a simple interface for interactively
editing images, and is capable of importing selected windows or the
entire desktop. GraphicsMagick can read and write over 88 image
formats, including JPEG, TIFF, WMF, SVG, PNG, PNM, GIF, and Photo CD.
It can resize, rotate, sharpen, color reduce, or add special effects to
the image and save the result to any supported format. GraphicsMagick
may be used to create animated or transparent .gifs, create composite
images, create thumbnail images, and much, much, more.

%description doc
Documentation for GraphicsMagick.

%description -n libGraphicsMagick
GraphicsMagick is an image manipulation program.
This package contains the libraries files you'll need to use
GraphicsMagick applications.

%description -n libGraphicsMagick-c++
This package contains the Magick++ library, a C++ binding to the
GraphicsMagick graphics manipulation library.

%description -n libGraphicsMagick-devel
GraphicsMagick is an image manipulation program.
This package contains the header files you'll need to develop
GraphicsMagick applications.

%description -n libGraphicsMagick-c++-devel
GraphicsMagick is an image manipulation program.
This package contains header files you'll need to develop
GraphicsMagick applications using the Magick++ C++ bindings.

%prep
%setup
%patch -p1
iconv -f iso-8859-2 -t utf8 < ChangeLog > ChangeLog.utf8
mv ChangeLog.utf8 ChangeLog
sed -i -e 's|"/lib /usr/lib|"/%_lib %_libdir|' configure
sed -ri \
    -e '/^MAGICK_CONFIGURE_PATH/ s,=.+$,=%buildroot%gmpath/config,' \
    -e '/^MAGICK_CODER_MODULE_PATH/ s,=.+$,=%buildroot%modulepath/coders,' \
    -e '/^MAGICK_FILTER_MODULE_PATH/ s,=.+$,=%buildroot%modulepath/filters,' \
    common.shi.in

%build
%add_optflags -DGRAPHICSMAGICK_DOCS_PATH=\\\"%_docdir/%name-%version/www/index.html\\\"
%configure \
           --enable-shared \
           --disable-static \
           --enable-libtool-lock \
           --enable-installed \
           --disable-symbol-prefix \
           %{subst_enable openmp} \
           --disable-openmp-slow \
           --with-modules \
           --with-magick-plus-plus \
           --without-perl \
           --without-fpx \
           --without-wmf \
           --with-quantum-depth=%quantum_depth \
           --with-frozenpaths \
           --with-windows-font-dir=%_datadir/fonts/ttf/ms \
           --with-fontpath=%_datadir/fonts/type1/urw \
           --with-gs-font-dir=%_datadir/fonts/type1/urw \
           #
%make_build \
    MAGICK_CODER_MODULE_PATH=%modulepath/coders \
    MAGICK_FILTER_MODULE_PATH=%modulepath/filters

%install
%makeinstall_std docdir=%_docdir/%name-%version
find %buildroot%_libdir/%name-%version -type f -name '*.la' -delete
bzip2 --best --keep --force %buildroot%_docdir/%name-%version/{ChangeLog,NEWS}*

%check
make check

%files
%doc %_docdir/%name-%version/Copyright.txt
%dir %_docdir/%name-%version

%_bindir/gm
%_datadir/%name-%version
%_man1dir/gm.*
%_man4dir/miff.*
%_man5dir/quantize.*

%files doc
%_docdir/%name-%version
%exclude %_docdir/%name-%version/Copyright.txt

%files -n libGraphicsMagick
%_libdir/libGraphicsMagick.so.*
%_libdir/libGraphicsMagickWand.so.*
%_libdir/%name-%version

%files -n libGraphicsMagick-c++
%_libdir/libGraphicsMagick++.so.*

%files -n libGraphicsMagick-devel
%_bindir/GraphicsMagick-config
%_bindir/GraphicsMagickWand-config
%dir %_includedir/GraphicsMagick
%_includedir/GraphicsMagick/wand
%_includedir/GraphicsMagick/magick
%_libdir/libGraphicsMagick.so
%_libdir/libGraphicsMagickWand.so
%_pkgconfigdir/GraphicsMagick.pc
%_pkgconfigdir/GraphicsMagickWand.pc
%_man1dir/GraphicsMagick-config.*
%_man1dir/GraphicsMagickWand-config.*

%files -n libGraphicsMagick-c++-devel
%_includedir/GraphicsMagick/Magick++.h
%_includedir/GraphicsMagick/Magick++
%_libdir/libGraphicsMagick++.so
%_pkgconfigdir/GraphicsMagick++.pc
%_bindir/GraphicsMagick++-config
%_man1dir/GraphicsMagick++-config.*

%changelog
