%def_disable snapshot

%define ver_major 3.46
%define xdg_name org.gtk.accerciser
%define uuid %name@%name.gnome.org

Name: accerciser
Version: %ver_major.2
Release: alt1

Summary: Interactive Python accessibility explorer
Group: Accessibility
License: BSD-3-Clause
Url: https://wiki.gnome.org/action/show/Apps/Accerciser

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

BuildArch: noarch

Requires: python3-module-%name = %EVR
Requires: python3-module-ipython
Requires: at-spi2-core

%add_python3_path %_datadir/%name
%add_python3_req_skip gi.repository.GLib
%add_python3_req_skip gi.repository.Gio

BuildRequires(pre): rpm-macros-meson rpm-build-python3 rpm-build-gir
BuildRequires: meson yelp-tools
BuildRequires: libgtk+3-devel python3-module-pygobject3-devel
BuildRequires: libat-spi2-core-devel
BuildRequires: python3-module-ipython
BuildRequires: /usr/bin/appstreamcli desktop-file-utils

%description
Accerciser is an interactive Python accessibility explorer for the GNOME
desktop. It uses AT-SPI2 to inspect and control widgets, allowing you to check
if an application is providing correct information to assistive technologies
and automated test frameworks. Accerciser has a simple plugin framework which
you can use to create custom views of accessibility information.

%package -n python3-module-%name
Summary: Python module for accerciser
Group: Development/Python3
BuildArch: noarch
Requires: typelib(Gtk) = 3.0 libgtk+3-gir >= 3.24
Requires: typelib(Wnck) = 3.0

%description -n python3-module-%name
An interactive Python accessibility explorer.

This package contains Python module for accerciser.

%package -n gnome-shell-extension-%name
Summary: GNOME Shell extension for Accerciser
Group: Graphical desktop/GNOME
Requires: gnome-shell >= 46
Requires: %name = %EVR

%description -n gnome-shell-extension-%name
GNOME Shell extension for the Accerciser accessibility explorer.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install
desktop-file-install --dir %buildroot%_desktopdir \
    --add-category=X-Development-Accessibility \
        %buildroot%_desktopdir/%name.desktop

%find_lang --with-gnome %name

%check
%__meson_test

%files -f %name.lang
%_bindir/*
%_datadir/%name
%_desktopdir/%name.desktop
%_man1dir/*
%_datadir/glib-2.0/schemas/*
%_datadir/icons/hicolor/*/*/%name.png
%_datadir/icons/hicolor/scalable/apps/accerciser.svg
%_datadir/icons/hicolor/symbolic/apps/accerciser-symbolic.svg
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc AUTHORS README* COPYING NEWS

%files -n python3-module-%name
%python3_sitelibdir/%name/

%files -n gnome-shell-extension-%name
%_datadir/gnome-shell/extensions/%uuid/

%changelog
