%define lib_name	libaiksaurus
%define lib_namegtk	%{lib_name}-gtk

Name: aiksaurus
Version: 1.2.1
Release: alt5

Summary: An English-language thesaurus library

License: GPL
Group: Text tools
Url: http://sourceforge.net/projects/aiksaurus/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: http://prdownloads.sf.net/%name/%name-%version.tar.bz2
Source: %name-%version.tar
Source1: %name.png
Source2: %name.desktop

Patch: %name-gcc43.patch
Patch1: %name-security.patch

Requires: %name-data

# manually removed: gcc-g77
# Automatically added by buildreq on Sun Jun 22 2008
BuildRequires: gcc-c++ libgtk+2-devel
BuildRequires: desktop-file-utils

%description
Aiksaurus is an English-language thesaurus library that can be
embedded in word processors, email composers, and other authoring
software to provide thesaurus capabilities.
This package contains a basic command line thesaurus program.

Install Aiksaurus if you want to have a thesaurus available on
your computer.

%package -n %name-data
Summary: An English-language thesaurus library
Group: Text tools

%description -n %name-data
Aiksaurus is an English-language thesaurus library that can be
embedded in word processors, email composers, and other authoring
software to provide thesaurus capabilities.
This package contains the datafiles.

%package -n %lib_name
Summary: An English-language thesaurus library
Group: Text tools
Requires: %name-data

%description -n %lib_name
Aiksaurus is an English-language thesaurus library that can be
embedded in word processors, email composers, and other authoring
software to provide thesaurus capabilities.
This package contains these libraries.

Install Aiksaurus if you want to have a thesaurus available on
your computer.

%package -n %lib_name-devel
Summary: Libraries and include files for Aiksuarus
Group: Development/C
Requires: %lib_name = %version-%release

%description -n %lib_name-devel
Aiksaurus is an English-language thesaurus library that can be
embedded in word processors, email composers, and other authoring
software to provide thesaurus capabilities.
This package contains the libraries and includes files necessary to develop
applications with Aiksaurus.

%package -n %{name}-gtk
Summary: A GTK+ thesaurus application
Group: Text tools

%description -n %{name}-gtk
Aiksaurusgtk is a GTK+ interface to the Aiksaurus library.
It provides an attractive thesaurus interface, and can be embedded
in GTK+ projects, notably AbiWord.
This package provides the standalone GTK+ interface.

%package -n %lib_namegtk
Summary: Libraries for aiksaurusgtk
Group: Text tools

%description -n %lib_namegtk
Aiksaurusgtk is a GTK+ interface to the Aiksaurus library.
It provides an attractive thesaurus interface, and can be embedded
in GTK+ projects, notably AbiWord.
This package provides the library files for aiksaurusgtk.

%package -n %lib_namegtk-devel
Summary: A GTK+ thesaurus library
Group: Development/C
Requires: %lib_namegtk = %version-%release

%description -n %lib_namegtk-devel
This package contains the libraries and includes files necessary to develop
applications with Aiksaurusgtk.

%prep
%setup
%patch
%patch1 -p1

%build
export CXXFLAGS="-std=c++14 $RPM_OPT_FLAGS"
%configure
sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
%make_build

%install
%makeinstall_std

install -D -m644 %SOURCE1 %buildroot%_niconsdir/%name.png
install -D -m644 %SOURCE2 %buildroot%_desktopdir/g%name.desktop
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Utility \
	--remove-category=Application \
	--add-category=Office \
	--add-category=TextTools \
	--add-category=Dictionary \
	%buildroot%_desktopdir/gaiksaurus.desktop

%files
%doc ChangeLog README AUTHORS
%_bindir/aiksaurus
%_bindir/caiksaurus

%files -n %name-data
%dir %_datadir/aiksaurus
%_datadir/aiksaurus/*.dat

%files -n %lib_name
%_libdir/libAiksaurus-*.so.*

%files -n %lib_name-devel
%_libdir/libAiksaurus.so
%_pkgconfigdir/aiksaurus-1.0.pc
%dir %_includedir/Aiksaurus
%_includedir/Aiksaurus/Aiksaurus.h
%_includedir/Aiksaurus/AiksaurusC.h

%files -n %{name}-gtk
%_bindir/gaiksaurus
%_desktopdir/g%name.desktop
%_niconsdir/%name.png

%files -n %lib_namegtk
%_libdir/libAiksaurusGTK-*.so.*

%files -n %lib_namegtk-devel
%_libdir/libAiksaurusGTK.so
%_pkgconfigdir/gaiksaurus-1.0.pc
%_includedir/Aiksaurus/AiksaurusGTK*.h

%changelog
