%define ver_major 3.56
%define xdg_name org.gnome.alacarte

%def_enable documentation
%def_enable check

Name: alacarte
Version: %ver_major.0
Release: alt1

Summary: Menu editor for GNOME
License: LGPL-2.0-or-later
Group: Graphical desktop/GNOME
Url: https://www.gnome.org

Vcs: https://gitlab.gnome.org/GNOME/alacarte.git

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

BuildArch: noarch

%define menus_ver 3.5.3

Requires: python3-module-pygobject3
Requires: typelib(Gtk) = 3.0

BuildRequires(pre): rpm-build-python3 rpm-build-gir
BuildRequires: pkgconfig(libgnome-menu-3.0) >= %menus_ver
BuildRequires: pkgconfig(pygobject-3.0)
%{?_enable_documentation:BuildRequires: docbook-dtds docbook-style-xsl xsltproc}
%{?_enable_check:BuildRequires: /usr/bin/desktop-file-validate /usr/bin/appstreamcli
BuildRequires: /usr/bin/glib-compile-schemas}

%description
Alacarte is a menu editor for GNOME using the freedesktop.org menu
specification.

%prep
%setup

%build
%configure \
    %{subst_enable documentation}
%nil
%make_build

%install
%makeinstall_std
%find_lang --with-gnome %name

%check
%make -k check VERBOSE=1

%files -f %name.lang
%python3_sitelibdir_noarch/Alacarte/
%_bindir/*
%_datadir/applications/*
%_datadir/%name/
%_iconsdir/hicolor/*x*/apps/%name.png
%{?_enable_documentation:%_man1dir/%name.1.*}
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc README* AUTHORS NEWS

%changelog
