%def_enable snapshot

%define ver_major 0.12
%define xdg_name org.gnome.Almanah

%def_enable eds
%def_enable check

Name: almanah
Version: %ver_major.4
Release: alt1

Summary: Diary editor for GNOME
License: GPL-3.0-or-later
Group: Graphical desktop/GNOME
Url: http://wiki.gnome.org/Apps/Almanah_Diary

Vcs: https://gitlab.gnome.org/GNOME/almanah.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.68

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson
BuildRequires: libgio-devel >= %glib_ver pkgconfig(gtksourceview-4) pkgconfig(gtkspell3-3.0)
BuildRequires: pkgconfig(sqlite3) libcryptui-devel pkgconfig(gcr-4) libgpgme-devel
%{?_enable_eds:BuildRequires: evolution-data-server-devel >= 3.5.91}
%{?_enable_check:BuildRequires: /usr/bin/appstreamcli desktop-file-utils}

%description
Almanah is a small GTK+3 application to allow you to keep a diary of your life.

%prep
%setup

%build
%meson \
    %{subst_enable_meson_feature eds evolution}
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

desktop-file-install --dir %buildroot%_desktopdir \
    --add-category=TextTools \
    %buildroot%_desktopdir/%xdg_name.desktop

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*x*/apps/%xdg_name.png
%_iconsdir/hicolor/scalable/*/%xdg_name-*.svg
%config %_datadir/glib-2.0/schemas/org.gnome.%name.gschema.xml
#%_datadir/GConf/gsettings/%name.convert
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc README* AUTHORS NEWS*

%changelog
