%{expand: %(sed 's,^%%,%%global ,' /usr/lib/rpm/macros.d/ubt)}
%define ubt_id %__ubt_branch_id

%ifver_gteq %ubt_id M110
%define qtver 6
%else
%define qtver 5
%endif

Name: alt-csp-cryptopro
Version: 0.3.3
Release: alt1

Group: File tools
Summary: CryptoPRO GUI tool
License: GPL-2.0-or-later

Source: %name-%version.tar

BuildRequires: cmake

BuildRequires(pre): rpm-build-kf%qtver rpm-build-ubt rpm-macros-ifver
BuildRequires: quazip-qt%qtver-devel
BuildRequires: qt%qtver-tools-devel

Provides: alt-csp-cryptopro-mate = %EVR
Obsoletes: alt-csp-cryptopro-mate < %EVR
Provides: alt-csp-cryptopro-kde = %EVR
Obsoletes: alt-csp-cryptopro-kde < %EVR

%description
CryptoPRO GUI tool

%prep
%setup

%build
%if %qtver == 6
%K6init no_altplace
%define Kbuild %K6build
%define Kinstall %K6install
%define _Kdata %_K6data
%else
%K5init no_altplace
%define Kbuild %K5build
%define Kinstall %K5install
%define _Kdata %_K5data
%endif
%Kbuild \
    -DQT_MAJOR_VERSION=%qtver \
    #

%install
%Kinstall
%if %qtver == 6
mkdir -p %buildroot/%_qt6_translationdir/
install -m 0644 BUILD/*.qm %buildroot/%_qt6_translationdir/
%else
mkdir -p %buildroot/%_qt5_translationdir/
install -m 0644 BUILD/*.qm %buildroot/%_qt5_translationdir/
%endif
%find_lang --with-qt --all-name %name

%files -f %name.lang
%_bindir/alt-csp-cryptopro
%_desktopdir/alt-csp-cryptopro.desktop
%_iconsdir/hicolor/*/apps/alt-csp-cryptopro.*
%_Kdata/kio/servicemenus/alt-csp-cryptopro.desktop
%_datadir/file-manager/actions/alt-csp-cryptopro.desktop

%changelog
