%define _hooksdir %_sysconfdir/hooks/hostname.d

Name: alterator-auth
Version: 0.48
Release: alt1

Summary: Alterator module for system wide auth settings
License: GPL-2.0+
Group: System/Configuration/Other

Requires: alterator >= 4.7-alt4
Requires: alterator-l10n >= 2.9.114-alt1
Requires: pam-config >= 1.9.1-alt1
Requires: pam_krb5
Requires: libnss-myhostname
Requires: libnss-role >= 0.5.6-alt1
Requires: avahi-daemon
Requires: bind-utils
Requires: local-policy >= 0.4.8-alt1
Requires: alterator-default-configs >= 0.0.2-alt1

Source: %name-%version.tar

BuildRequires(pre): alterator >= 5.0
BuildRequires(pre): alterator-lookout
BuildRequires: guile22-devel

%filter_from_requires /^samba-common$/d;/^systemd/d;/^gpupdate$/d;/gpupdate-setup/d

%description
Alterator module for system wide auth settings

%package -n task-auth-ad-winbind
Summary: Metapackage to authenticate in Active Directory domain by winbind
Group: System/Configuration/Other
Requires: alterator-auth
Requires: samba-winbind
Requires: samba-winbind-clients
Requires: samba-common-tools
Requires: krb5-kinit
Requires: pam_mount
Requires: libnss-role
Requires: alterator-datetime
Requires: samba-winbind-dnsupdate
Requires: system-report
Requires: diag-domain-client
Requires: samba >= 4.21
Requires: samba-common-tools

%description -n task-auth-ad-winbind
Metapackage to authenticate in Active Directory domain by Winbind.

%package -n task-auth-ad-sssd
Summary: Metapackage to authenticate in Active Directory domain by sssd
Group: System/Configuration/Other
Requires: alterator-auth
Requires: sssd-ad
Requires: samba-common-tools
Requires: krb5-kinit
Requires: pam_mount
Requires: libnss-role
Requires: alterator-datetime
Requires: sssd-dbus
Requires: alterator-roles-common
Requires: samba-winbind-clients
Requires: sssd-tools
Requires: adcli
Requires: system-report
Requires: diag-domain-client
Requires: samba >= 4.21
Requires: samba-common-tools

Provides:  task-auth-ad = %EVR
Obsoletes: task-auth-ad < %EVR

%description -n task-auth-ad-sssd
Metapackage to authenticate in Active Directory domain by SSSD.

%package -n task-auth-ldap-sssd
Summary: Metapackage to authenticate in LDAP domain by sssd
Group: System/Configuration/Other
Requires: alterator-auth
Requires: sssd-ldap
Requires: sssd-krb5
Requires: krb5-kinit
Requires: pam_mount
Requires: libnss-role
Requires: alterator-roles-common

Provides:  task-auth-ldap = %EVR
Obsoletes: task-auth-ldap < %EVR

%description -n task-auth-ldap-sssd
Metapackage to authenticate in LDAP domain by SSSD.

%package -n task-auth-freeipa
Summary: Metapackage to authenticate in FreeIPA domain
Group: System/Configuration/Other
Requires: alterator-auth
Requires: freeipa-client
Requires: krb5-kinit
Requires: pam_mount
Requires: libnss-role
Requires: libsss_sudo
Requires: alterator-datetime
Requires: alterator-roles-common

%description -n task-auth-freeipa
Metapackage to authenticate in FreeIPA domain.

%package -n alterator-roles-common
Summary: Common package with default roles and privileges
Group: System/Configuration/Other
Requires: libnss-role >= 0.5.1

%description -n alterator-roles-common
Common package with default roles and privileges.
Contains basic roles: users, power and localadmins.

%prep
%setup

%build
%make_build libdir=%_libdir

%install
export GUILE_LOAD_PATH=/usr/share/alterator/lookout
%makeinstall
install -Dpm644 etc/user-groups %buildroot%_sysconfdir/alterator/auth/user-groups
install -Dpm644 etc/admin-groups %buildroot%_sysconfdir/alterator/auth/admin-groups
install -Dpm644 etc/role.d/users.role %buildroot%_sysconfdir/role.d/users.role
install -Dpm644 etc/role.d/powerusers.role %buildroot%_sysconfdir/role.d/powerusers.role
install -Dpm644 etc/role.d/localadmins.role %buildroot%_sysconfdir/role.d/localadmins.role
install -Dpm755 sbin/system-auth %buildroot/%_sbindir/system-auth
install -Dpm755 hooks/auth %buildroot/%_hooksdir/90-auth
rm -f %buildroot%_libexecdir/alterator/hooks/auth

%pre -n alterator-roles-common
%_sbindir/groupadd -r -f -g 98 everyone 2> /dev/null ||:
#_sbindir/groupadd -r -f -g 99 nobody 2> /dev/null ||:
#_sbindir/groupadd -r -f -g 100 users 2> /dev/null ||:
%_sbindir/groupadd -r -f -g 101 localadmins 2> /dev/null ||:
%_sbindir/groupadd -r -f -g 102 powerusers 2> /dev/null ||:
%_sbindir/groupadd -r -f -g 103 guests 2> /dev/null ||:
%_sbindir/groupadd -r -f -g 104 accountops 2> /dev/null ||:
%_sbindir/groupadd -r -f -g 105 serverops 2> /dev/null ||:
%_sbindir/groupadd -r -f -g 106 printops 2> /dev/null ||:
%_sbindir/groupadd -r -f -g 107 backupops 2> /dev/null ||:
%_sbindir/groupadd -r -f -g 108 replicators 2> /dev/null ||:
%_sbindir/groupadd -r -f -g 109 networkops 2> /dev/null ||:
%_sbindir/groupadd -r -f -g 110 remote 2> /dev/null ||:

%files
%config(noreplace) %_sysconfdir/alterator/auth/user-groups
%config(noreplace) %_sysconfdir/alterator/auth/admin-groups
%_alterator_datadir/applications/*
%_alterator_datadir/ui/*/
%_alterator_libdir/ui/auth/*.go
%_sbindir/system-auth
%_hooksdir/90-auth
%_alterator_backend3dir/*

%files -n alterator-roles-common
%config(noreplace) %_sysconfdir/role.d/users.role
%config(noreplace) %_sysconfdir/role.d/powerusers.role
%config(noreplace) %_sysconfdir/role.d/localadmins.role

%files -n task-auth-ad-winbind

%files -n task-auth-ad-sssd

%files -n task-auth-ldap-sssd

%files -n task-auth-freeipa

%changelog
