%define _unpackaged_files_terminate_build 1
%define shortname edition

Name: alterator-backend-%{shortname}
Version: 0.4.0
Release: alt1

Summary: Alterator backend for edition
License: GPLv2+
Group: System/Configuration/Other
URL: https://altlinux.space/alterator/alterator-backend-edition

BuildArch: noarch
Source: %name-%version.tar

Requires: alterator-interface-%{shortname}
Requires: alterator-backend-%{shortname}-utils = %EVR
Requires: alterator-module-executor >= 0.1.19

BuildRequires(pre): rpm-macros-alterator
BuildRequires: python3-devel

%description
%summary.

%package -n alterator-interface-%{shortname}
Summary: Alterator interface for edition
Group: System/Configuration/Other

%description -n alterator-interface-%{shortname}
%summary.

%package -n alterator-backend-%{shortname}-utils
Summary: Scripts for alterator-backend-%{shortname}
Group: System/Configuration/Other

Requires: alterator-entry >= 0.2.0
Requires: distro-licenses
Requires: dconf

%description -n alterator-backend-%{shortname}-utils
%summary.

%prep
%setup

%install
%makeinstall_std
install -v -p -m 755 -D backend/%{shortname}.d/alterator-backend-edition.filetrigger %buildroot%_rpmlibdir/10-alterator-backend-edition.filetrigger

%files
%dir %_alterator_datadir/backends
%_alterator_datadir/backends/current_edition.backend
%dir %_alterator_libdir/backends/%{shortname}.d
%_alterator_libdir/backends/%{shortname}.d/generate-editions-backends
%_rpmlibdir/10-alterator-backend-edition.filetrigger

%files -n alterator-interface-%{shortname}
%dir %_datadir/dbus-1
%dir %_datadir/dbus-1/interfaces
%dir %_datadir/polkit-1
%dir %_datadir/polkit-1/actions
%dir %_datadir/glib-2.0
%dir %_datadir/glib-2.0/schemas
%_datadir/dbus-1/interfaces/*.xml
%_datadir/polkit-1/actions/*.policy
%_datadir/glib-2.0/schemas/org.altlinux.alterator.edition.gschema.xml

%files -n alterator-backend-%{shortname}-utils
%_alterator_libdir/backends/%{shortname}

%post
%_alterator_libdir/backends/%{shortname}.d/generate-editions-backends

%preun
if [ $1 = 0 ]; then
    find %_sysconfdir/alterator/backends -name "autogenerated-edition-*.backend" -type f -delete
fi

%changelog
