Name: alterator-ulogd
Version: 2.0.1
Release: alt1

Summary: alterator module for network traffic statistics
License: GPL
Group: System/Configuration/Other
Url: http://wiki.sisyphus.ru/Alterator

Source: %name-%version.tar

BuildArch: noarch

Requires(post): sqlite3
Requires: alterator >= 3.5 gettext etcnet
Requires: ulogd-sqlite3 >= 2.0.2-alt1
Requires: alterator-net-iptables >= 4.3-alt1
Requires: libshell alterator-net-functions alterator-sh-functions
Requires: alterator-service-functions
Requires: alterator-l10n >= 2.5-alt14

BuildPreReq: alterator >= 3.5-alt2

# Automatically added by buildreq on Mon Jul 11 2005 (-bi)
BuildRequires: alterator

%define old_sqlite3db %_localstatedir/ulogd/sqlite3.db
%define sqlite3db %_localstatedir/ulogd/alterator_sqlite3.db
%define ulogd_conf %_sysconfdir/ulogd.conf
%define init_db %_libexecdir/%name/init-db.sh

%description
Iptables traffic statistics alterator module

%prep
%setup -q

%build
%make_build

%install
%makeinstall
install -D -m644 ulogd.scheme %buildroot/%_datadir/%name/ulogd.scheme

%post
if [ $1 -eq 1 ]; then
	%init_db %ulogd_conf %sqlite3db ||:
	. /usr/bin/alterator-service-functions
	service_control ulogd condreload ||:
fi

# Migrate old configuration and change sqlite3 database
%triggerpostun -- %name < 2.0.1-alt1
if [ ! -f %sqlite3db ]; then
	. /usr/bin/alterator-service-functions
	need_restart=
	if service_control ulogd is-active; then
		need_restart=1
		service_control ulogd stop ||:
	fi
	[ -f %ulogd_conf.rpmnew ] &&
	ulogd_conf_file=%ulogd_conf.rpmnew ||
	ulogd_conf_file=%ulogd_conf
	tmp_conf="$(mktemp /tmp/ulogd.conf.XXXXXX)"
	cp "$ulogd_conf_file" "$tmp_conf"
	if [ -f %old_sqlite3db ]; then
		cp -a %old_sqlite3db %sqlite3db &&
		sqlite3 %sqlite3db 'DROP TABLE ulog;'
	fi
	%init_db "$tmp_conf" %sqlite3db &&
	mv -b --suffix=.bak "$tmp_conf" %ulogd_conf &&
	chmod 0640 %ulogd_conf &&
	rm -f %old_sqlite3db
	[ -n "$need_restart" ] && service_control ulogd start ||:
fi	

%files
%_alterator_backend3dir/*
%_libexecdir/%name/
%_datadir/alterator/applications/*
%_datadir/alterator/ui/*/
%_datadir/%name

%changelog
