Name: anacron
Version: 2.3
Release: alt7
Epoch: 1

Summary: A cron-like program that doesn't go by time
License: GPLv2+
Group: System/Servers
Url: http://anacron.sourceforge.net/

# http://download.sourceforge.net/anacron/anacron-%version.orig.tar.bz2
Source: anacron-%version.orig.tar
Source1: anacrontab
Source2: anacron.init
Source3: run-anacronjobs
Source4: anacronjobs.sysconfig
Source5: anacron.service

Patch1: anacron-2.3-re.patch
Patch2: anacron-2.3-alt-lock-file.patch

%define lockfile %_lockdir/subsys/anacron

%description
Anacron (like `anac(h)ronistic') is a periodic command scheduler.  It
executes commands at intervals specified in days.  Unlike cron, it
does not assume that the system is running continuously.  It can
therefore be used to control the execution of daily, weekly and
monthly jobs (or anything with a period of n days), on systems that
don't run 24 hours a day.  When installed and configured properly,
Anacron will make sure that the commands are run at the specified
intervals as closely as machine-uptime permits.

This package is pre-configured to execute the daily jobs of the OS.
You should install this program if your system isn't powered on
24 hours a day to make sure the maintenance jobs of other packages
are executed each day.

%prep
%setup
%patch1 -p1
%patch2 -p1
rm gregor.*

%build
%add_optflags -D_GNU_SOURCE -DLOCKFILE=\\\"%lockfile\\\"
%make_build

%install
install -pD -m755 anacron %buildroot%_sbindir/anacron
install -pD -m644 anacron.8 %buildroot%_mandir/man8/anacron.8
install -pD -m644 anacrontab.5 %buildroot%_mandir/man5/anacrontab.5
install -pD -m644 %_sourcedir/anacrontab %buildroot/etc/anacrontab
install -pD -m755 %SOURCE2 %buildroot%_initdir/anacron
install -pD -m755 %SOURCE3 %buildroot%_bindir/run-anacronjobs
install -pD -m644 %SOURCE4 %buildroot/etc/sysconfig/anacronjobs
install -pD -m644 %_sourcedir/anacron.service %buildroot%_unitdir/anacron.service

mkdir -p %buildroot/etc/sysconfig/limits.d
ln -s crond %buildroot/etc/sysconfig/limits.d/anacron

mkdir -p %buildroot/var/{run,spool}/anacron

for f in cron.{dai,week,month}ly; do
	mkdir -p "%buildroot/etc/$f"
cat << EOF >"%buildroot/etc/$f/000%name"
#!/bin/sh
#
# %name's cron script
#
# This script updates %name time stamps. It is called through run-parts
# either by %name itself or by cron.
#
# The script is called "000%name" to assure that it will be executed
# _before_ all other scripts.

exec %_sbindir/anacron -u $f
EOF
chmod 750 "%buildroot/etc/$f/000%name"
done

sed -i s,RPM_LOCKFILE,%lockfile, %buildroot%_initdir/%name

%post
%post_service %name

%preun
%preun_service %name

%files
%_bindir/run-anacronjobs
%_sbindir/anacron
/etc/sysconfig/limits.d/anacron
%_unitdir/anacron.service
%config(noreplace) %_initdir/anacron
%config(noreplace) %attr(640,root,adm) /etc/anacrontab
%config(noreplace) %attr(640,root,adm) /etc/sysconfig/anacronjobs
%config(noreplace) /etc/cron.*/*
%_mandir/man?/*
%attr(700,root,root) /var/*/anacron
%doc ChangeLog README TODO

%changelog
