%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1

Name: apt
Version: 0.5.15lorg2
Release: alt97

Summary: Debian's Advanced Packaging Tool with RPM support
Summary(ru_RU.UTF-8): Debian APT - Усовершенствованное средство управления пакетами с поддержкой RPM
License: GPL-2.0-or-later
Group: System/Configuration/Packaging
URL: http://apt-rpm.org
# Known upstream "apt-rpm" Git repos:
# -----------------------------------
#
# * http://apt-rpm.org/scm/apt.git -- I've named this remote "apt-rpm";
# * https://gitlab.com/apt-rpm/apt-rpm.git -- "apt-rpm@gitlab"
#   (and its clone on Github: https://github.com/arelixlinux/apt
#    -- "apt-rpm@github").
#
# "apt-rpm@gitlab" has a few more recent commits than "apt-rpm", a deeper
# history (into the past), and some better formatted commit headers (Author).
# (Compare like this: git range-diff apt-rpm/master...apt-rpm@gitlab/master)
#
# To graft it (the deeper "apt-rpm@gitlab" history) to ALT's history locally for yourself:
#
# git replace --graft 0.5.15lorg2-alt3 49dff175fb8ea3cd3ef47d45836f3089838246d6 0.5.15cnc6-alt18
#
# Then git blame on the source code gives more interesting information.
# If the two parents are in this order, git blame --first-parent -w shows more
# intersting individual commits from Conectiva's history, and not ALT's one.
# (Make sure that the grafted source code is identical to ours:
#
# git tag apt-rpm@gitlab/apt-0.5.15lorg2 49dff175fb8ea3cd3ef47d45836f3089838246d6
# git diff apt-rpm@gitlab/apt-0.5.15lorg2..0.5.15lorg2-alt3 --stat | fgrep -v ' => '
#
# The only reported difference is that they added a contributed script.)
#
# The upstream Debian repo:
# -------------------------
#
# https://salsa.debian.org/apt-team/apt.git -- "Debian"
#
# To attach it to Conectiva's history (locally for yourself):
#
# git tag apt-rpm@gitlab/MERGED-0.5.4.9 b780834d0d29cca5b0af1b544d3ff7b2a3d1a7a8
# git tag Debian/0.5.4.9-MERGED-into-apt-rpm 4968036c93552ff78c1f857a91c685f0f3bcb794
# git replace --graft apt-rpm@gitlab/MERGED-0.5.4.9 Debian/0.5.4.9-MERGED-into-apt-rpm apt-rpm@gitlab/MERGED-0.5.4.9^
#
# The parent with the richer history is 1st for git blame --first-parent -w.
#
# Grafting the most recent merge of Debian into apt-rpm:
#
# git replace --graft c5f4905b15ac022e6b18cf8acf59a4961210f3f9 725581a78ed5b222f7290321917199fb7fbc4c79 c5f4905b15ac022e6b18cf8acf59a4961210f3f9^
# git tag Debian/0.5.15 725581a78ed5b222f7290321917199fb7fbc4c79
# git tag apt-rpm@gitlab/MERGED-0.5.15 c5f4905b15ac022e6b18cf8acf59a4961210f3f9
#
# Enhanced apt-rpm history
# ------------------------
#
# I've enhanced the apt-rpm history (for future rebases and cherry-picks
# into ALT) and put it into the "next" remote (apt-rpm_next repo); branches:
#
# 0.5.15sisyphus0/apt-rpm -- brings the apt-repomd branch into the linear history;
# 0.5.15sisyphus1/apt-rpm -- fixes whitespace issues.
#
# It makes sense to graft it into our history (so that merges are hopefully
# simpler):
#
# git replace --graft 00dc7947063a474cafd29c6c1fb1185609eb0c6b 00dc7947063a474cafd29c6c1fb1185609eb0c6b^ next/0.5.15sisyphus1/fix-whitespace
#
Vcs: git://git.altlinux.org/gears/a/apt.git
Source0: %name-%version-%release.tar

Requires: libapt = %EVR
Requires: rpm >= 4.13.0.1-alt2, /etc/apt/pkgpriorities, apt-conf
Requires: librpmio(PGPHASHALGO_BLAKE2B)%{?_is_libsuff:(%{_libsuff}bit)} = 100
# We need (lib)rpm which finds pkgs by labels in N-E:V-R@T format:
Requires: RPMQ(EPOCH)
Requires: RPMQ(BUILDTIME)
Requires: RPMQ(DISTTAG)
# for methods.
Requires: gzip, bzip2, xz
Requires: gnupg, alt-gpgkeys

# Older versions of update-kernel misunderstood the @-postfix (with buildtime
# and disttag), which is now added by APT to verstrs and the names of
# allow-duplicated pkgs. (Epoch was also treated differently before, but that
# was not important until we added disttags, which are also separated by :.)
Conflicts: update-kernel < 0.9.14-alt1
# Older versions of apt-scripts-nvidia relied on a certain format of the APT ids
# of allow-duplicated packages, which changed (due to appending buildtime).
Conflicts: apt-scripts-nvidia < 0.5.0-alt1

# for apt-pipe.
BuildPreReq: setproctitle-devel

%def_disable static
%{?_enable_static:BuildPreReq: glibc-devel-static}

# should be same version in rpm.spec
BuildPreReq: liblua5.3-devel

BuildRequires: docbook-utils gcc-c++ libreadline-devel librpm-devel setproctitle-devel
BuildRequires: libgnutls-devel

%package -n libapt
Summary: APT's core libraries
Group: System/Libraries
# RPMTAG_AUTOINSTALLED is supported since 4.13.0.1-alt2.
Requires: librpm7 >= 4.13.0.1-alt2

%package -n libapt-devel
Summary: Development files and documentation for APT's core libs
Summary(ru_RU.UTF-8): Файлы и документация для разработчиков, использующих библиотеки APT
Group: Development/C
Requires: libapt = %EVR, librpm-devel >= 4.13.0.1-alt2

%package -n libapt-devel-static
Summary: Development static library for APT's libs
Summary(ru_RU.UTF-8): Статическая библиотека APT для разработчиков, использующих библиотеки APT
Group: Development/C
Requires: libapt-devel = %EVR, librpm-devel-static >= 4.13.0.1-alt2

%package rsync
Summary: rsync method support for APT
Summary(ru_RU.UTF-8): Поддержка метода rsync для APT
Group: Development/Other
Requires: %name = %EVR, rsync >= 2.5.5-alt3

%package https
Summary: https method support for APT
Summary(ru_RU.UTF-8): Поддержка метода https для APT
Group: Other
Requires: %name = %EVR

%package tests
Summary: Test suite for APT
Summary(ru_RU.UTF-8): Набор тестов для APT
Group: Other
BuildArch: noarch
Requires: rpm-build
Requires: /usr/bin/genbasedir
# optional
%global complete_reqs_of_tests %name-https /usr/sbin/nginx tinyproxy /usr/bin/openssl
%global reqs_of_tests_to_filter_out \\(%name-https\\|/usr/sbin/nginx\\|nginx\\|/usr/bin/openssl\\|openssl\\|/usr/bin/tinyproxy\\|tinyproxy\\)
%filter_from_requires \,^%reqs_of_tests_to_filter_out\($\|[[:blank:]]\),d

# {{{ descriptions
%define risk_usage_en This package is still under development.

%description
A port of Debian's APT tools for RPM based distributions,
or at least for Conectiva. It provides the apt-get utility that
provides a simpler, safer way to install and upgrade packages.
APT features complete installation ordering, multiple source
capability and several other unique features.

%risk_usage_en

%define risk_usage Данный пакет пока еще находится в стадии разработки.

%description -l ru_RU.UTF-8
Перенесенные из Debian средства управления пакетами APT, включающие
в себя поддержку RPM, выполненную компанией Conectiva (Бразилия).
Этот пакет содержит утилиту apt-get для простой и надежной установки
и обновления пакетов. APT умеет автоматически разрешать зависимости
при установке, обеспечивает установку из нескольких источников и
целый ряд других уникальных возможностей.

%risk_usage

%description -n libapt
This package contains APT's package manipulation library,
modified for RPM.

%risk_usage_en

%description -n libapt-devel
This package contains the header files and libraries for developing with
APT's package manipulation library, modified for RPM.

%risk_usage_en

%description -n libapt-devel-static
This package contains static libraries for developing with APT's
package manipulation library, modified for RPM.

%risk_usage_en

%description rsync
This package contains method 'rsync' for APT.

%risk_usage_en

%description https
This package contains method 'https' for APT.

%risk_usage_en

%description tests
This package contains test suite for APT.

%description -n libapt -l ru_RU.UTF-8
В этом пакете находится библиотеки управления пакетами
из комплекта APT. В отличие от оригинальной версии для Debian, этот
пакет содержит поддержку для формата RPM.

%risk_usage

%description -n libapt-devel -l ru_RU.UTF-8
В этом пакете находятся заголовочные файлы и библиотеки для разработки
программ, использующих библиотеки управления пакетами
из комплекта APT. В отличие от оригинальной версии для Debian, этот
пакет содержит поддержку для формата RPM.

%risk_usage

%description -n libapt-devel-static -l ru_RU.UTF-8
В этом пакете находятся статические библиотеки для разработки программ,
использующих библиотеки управления пакетами из
комплекта APT. В отличие от оригинальной версии для Debian, этот пакет
содержит поддержку для формата RPM.

%risk_usage

%description rsync -l ru_RU.UTF-8
В этом пакете находится метод 'rsync' для APT

%risk_usage

%description https -l ru_RU.UTF-8
В этом пакете находится метод 'https' для APT

%risk_usage

%description tests -l ru_RU.UTF-8
В этом пакете находится набор тестов для APT.

# }}}

%prep
%setup -n %name-%version-%release

./verify-src.sh

# Fix url.
sed -i 's,/usr/share/common-licenses/GPL,/usr/share/license/GPL,' COPYING

# Unhide potential cc/c++ errors.
sed -i 's, > /dev/null 2>&1,,' buildlib/tools.m4

%build
gettextize --force --quiet --no-changelog --symlink
%autoreconf

# support for std::optional (C++17), std::string::starts_with (C++20)
# (We set a GNU dialect in -std= in order to minimally diverge
# from GCC's default, which is also -std=gnu++NN.)
# FIXME: perhaps move this option (for implementation) to configure.ac
# as this is a property of the source code; put another option (for API)
# to pkgconfig.
%add_optflags -std=gnu++20
%ifarch %e2k
%remove_optflags -Wno-error
%endif

%configure --includedir=%_includedir/apt-pkg --enable-Werror %{subst_enable static}
echo '#define APTRPM_ID "%name-%{?epoch:%epoch:}%version-%release%{?disttag::%disttag}.%_target_cpu"' \
	>> include/config.h

# Probably this obsolete now?
find -type f -print0 |
	xargs -r0 grep -EZl '/var(/lib)?/state/apt' -- |
	xargs -r0 %__subst -p 's,/var\(/lib\)\?/state/apt,%_localstatedir/%name,g' --
%make_build

%install
mkdir -p %buildroot%_sysconfdir/%name/{%name.conf,sources.list,vendors.list,preferences}.d
mkdir -p %buildroot%_libdir/%name/scripts
mkdir -p %buildroot%_localstatedir/%name/{lists/partial,prefetch}
mkdir -p %buildroot%_cachedir/%name/{archives/partial,gen{pkg,src}list}
mkdir -p %buildroot%_libdir/%name/tests

%makeinstall includedir=%buildroot%_includedir/apt-pkg

install -pm644 apt.conf %buildroot%_sysconfdir/%name/
install -pm644 apt.conf.d/* -t %buildroot%_sysconfdir/%name/apt.conf.d/

# Cleanup
rm %buildroot%_libdir/*.la

bzip2 -9fk ChangeLog-rpm.old

find %buildroot%_includedir -type f -name '*.h' |while read f; do
	cat >>"$f" <<EOF

#include <stdint.h>
#if __WORDSIZE == 32 && !defined(__USE_FILE_OFFSET64)
# error "<${f#%buildroot%_includedir/}> cannot be used without -D_FILE_OFFSET_BITS=64"
#endif
EOF
done

mkdir -p %buildroot%_datadir/%name
cp -r test/integration -T %buildroot%_datadir/%name/tests

install -m0755 run-tests-dir -t %buildroot%_datadir/%name/
cp -r tests-under-pkdirect -t %buildroot%_datadir/%name/

%find_lang %name

unset RPM_PYTHON

%package basic-checkinstall
Summary: Immediately test %name when installing this package (only basic tests)
Group: Other
BuildArch: noarch
Requires(pre): %name-tests
Requires(pre): %name = %EVR

%description basic-checkinstall
Immediately test %name when installing this package.

The set of testcases is limited (just to the file method).

%files basic-checkinstall

%pre basic-checkinstall -p %_sbindir/sh-safely
set -o pipefail

# Check that %name-tests has no unwanted extra reqs:
found_unwanted_reqs_of_tests="$(rpm -q %name-tests -R |
				    { grep -e '%{reqs_of_tests_to_filter_out}' ||
				      [ $? -eq 1 ]; })"
if [ -n "$found_unwanted_reqs_of_tests" ]; then
    printf >&2 'These are unwanted extra reqs of %name-tests:\n%%s\n' \
	       "$found_unwanted_reqs_of_tests"
    exit 1
fi

pushd %_datadir/%name/tests/

# force the target arch for the tests
#
# By default, the packages would be built for the arch detected by rpm-build
# (rpmbuild --eval %%_arch). On installation, they would be compared
# by rpm for compatibility with the arch detected by rpm. Currently,
# the mismatch in the detection between rpm and rpm-build can lead to problems,
# at least, on armh. So, we set the target by force to a value that must work.
system_arch="$(rpm -q rpm --qf='%%{ARCH}')"
export APT_TEST_TARGET="$system_arch"

# cache built pkgs and other stuff
APT_TEST_INTERMEDIATES="$(mktemp -d)"
export APT_TEST_INTERMEDIATES

# this macro can be prefixed (e.g., by environment assignments),
# therefore the extra backslash in the first line
%global runtests \\\
		./run-tests -v

# A quick test with just one method for the case without APT_TEST_GPGPUBKEY.
APT_TEST_METHODS='file' APT_TEST_http_METHODS= %runtests

# The same tests, but just via cdrom with a missing release:
#APT_TEST_METHODS=cdrom_missing_release APT_TEST_http_METHODS= %%runtests

%package checkinstall
Summary: Immediately test %name when installing this package (complete set of tests)
Group: Other
BuildArch: noarch
Requires(pre): %name-tests
Requires(pre): %name = %EVR
Requires(pre): %complete_reqs_of_tests
Requires(pre): gpg-keygen

%description checkinstall
Immediately test %name when installing this package.

The set of testcases is complete (all the methods that are tested by default
and some additional peculiarities are tested).

%files checkinstall

%pre checkinstall -p %_sbindir/sh-safely
set -o pipefail
pushd %_datadir/%name/tests/

# This option makes sense just for the maintainer (to test the tests).
# This option makes the built pkgs be saved under a special filename
# (our alias). This mechanism is used to test pkgs with N-V-R that would be
# too long for filenames, in another run of the tests with
# APT_TEST_PKG_DECORATE_VERSION turned on. And here we just can make sure
# that the tests are robust with APT_TEST_PKG_FILENAME_BY_ALIAS alone.
# APT_TEST_PKG_FILENAME_BY_ALIAS=yes
# export APT_TEST_PKG_FILENAME_BY_ALIAS

# force the target arch for the tests
#
# By default, the packages would be built for the arch detected by rpm-build
# (rpmbuild --eval %%_arch). On installation, they would be compared
# by rpm for compatibility with the arch detected by rpm. Currently,
# the mismatch in the detection between rpm and rpm-build can lead to problems,
# at least, on armh. So, we set the target by force to a value that must work.
system_arch="$(rpm -q rpm --qf='%%{ARCH}')"
export APT_TEST_TARGET="$system_arch"

# prepare data for rpm --import
APT_TEST_GPGPUBKEY="$PWD"/example-pubkey.asc
gpg-keygen --passphrase '' \
	--name-real 'Some One' --name-email someone@example.com \
	/dev/null "$APT_TEST_GPGPUBKEY"

export APT_TEST_GPGPUBKEY

# cache built pkgs and other stuff
APT_TEST_INTERMEDIATES="$(mktemp -d)"
export APT_TEST_INTERMEDIATES

%runtests

# Everything has been tested by now.

%package xxtra-heavy-load-checkinstall
Summary: Immediately test %name when installing this package (many times under heavy load)
Group: Other
BuildArch: noarch
Requires(pre): %name-tests
Requires(pre): %name = %EVR
Requires(pre): %complete_reqs_of_tests
Requires(pre): gpg-keygen

%description xxtra-heavy-load-checkinstall
Immediately test %name when installing this package.

The tests are run many times and under simulated heavy load (namely,
in parallel) in order to possibly detect races
(to make sure no tests are randomly succeeding).

%files xxtra-heavy-load-checkinstall

%pre xxtra-heavy-load-checkinstall -p %_sbindir/sh-safely
set -o pipefail
pushd %_datadir/%name/tests/

# force the target arch for the tests
#
# By default, the packages would be built for the arch detected by rpm-build
# (rpmbuild --eval %%_arch). On installation, they would be compared
# by rpm for compatibility with the arch detected by rpm. Currently,
# the mismatch in the detection between rpm and rpm-build can lead to problems,
# at least, on armh. So, we set the target by force to a value that must work.
system_arch="$(rpm -q rpm --qf='%%{ARCH}')"
export APT_TEST_TARGET="$system_arch"

# prepare data for rpm --import
APT_TEST_GPGPUBKEY="$PWD"/example-pubkey.asc
gpg-keygen --passphrase '' \
	--name-real 'Some One' --name-email someone@example.com \
	/dev/null "$APT_TEST_GPGPUBKEY"

export APT_TEST_GPGPUBKEY

# cache built pkgs and other stuff
APT_TEST_INTERMEDIATES="$(mktemp -d)"
export APT_TEST_INTERMEDIATES

. ./run-tests.defaults.sh

all_unique_methods=('' $(for method in "${APT_TEST_ALL_METHODS[@]}" "${APT_TEST_ALL_http_METHODS[@]}"; do echo "$method"; done | sort -u))
readonly -a all_unique_methods

# Below we run the same tests many times in order to possibly catch
# bad races. (It's more probable to catch a race under heavy load;
# so, we do simultaneously as many as reasonable, possibly more than real nprocs.)

# To not run in parallel, build the pkg with --define 'nprocs_for_check %%nil'
# Consider multiplying `nproc` by 2 for heavier load.
NPROCS=`nproc`
if ! [ "$NPROCS" -gt 0 ] 2>/dev/null; then
	NPROCS=1
fi
NPROCS=$(( 2 * NPROCS )) # for heavier load
%{?nprocs_for_check:NPROCS=%nprocs_for_check}

already_once=0
job=0
# Repeat all, so that every one gets tested at least once under maximal load;
# this is the purpose of extra_job counter.
readonly EXTRA_JOBS=$((1 * NPROCS)) # just an arbitrary num of extra jobs at the end
for (( extra_job = 0; extra_job < EXTRA_JOBS; )); do
    for method in "${all_unique_methods[@]}"; do
	# We could do the same method several times by increasing the number here
	# (to provoke even more races), but there are already too many tests.
	for (( repeat = 0; repeat < 1; ++repeat )); do
	    # %%02d in order not to pass spaces in xargs' {} placeholder
	    printf '%%02d:%%s\n' "$((job++))" "$method"
	    if (( already_once && (++extra_job >= EXTRA_JOBS) )); then
		break 2
	    fi
	done
    done
    already_once=1
done >jobs

sed -i -Ee "s,^([^:]+):,\1/$job:," jobs

export NPROCS # for the embedded script (to show the total number of slots)
xargs <jobs \
      -d'\n' -I'{}' ${NPROCS:+-P$NPROCS --process-slot-var=PARALLEL_SLOT} \
      -- sh -efuo pipefail \
	  -c 'APT_RUN_TEST_ONLY_IF_METHOD_MATCHES={}
              APT_RUN_TEST_ONLY_IF_METHOD_MATCHES="${APT_RUN_TEST_ONLY_IF_METHOD_MATCHES#*:}"
              export APT_RUN_TEST_ONLY_IF_METHOD_MATCHES
              %runtests '${NPROCS:+'|& sed --unbuffered -e "s,^,[$(printf %%2d $PARALLEL_SLOT)/$NPROCS {}] ,"'}

%package under-pkdirect-checkinstall
Summary: Immediately test %name+PK when installing this package (via packagekit-direct)
Group: Other
BuildArch: noarch
Requires(pre): packagekit

%description under-pkdirect-checkinstall
Immediately test PackageKit (which is supposed to use %name as the backend)
when installing this package.

The testing is done via %_libexecdir/packagekit-direct (which works
without relying on any daemons, DBus, etc.)

Some of the bugs (from the past) which are being tested for by these
tests could only be seen with APT indices that were big and/or
acquired from "external" sources (like the real Sisyphus repo). So,
having just the "internal" system RPM db diminishes the potential
of these few tests to find interesting bugs. One should set up
"external" sources for APT (in a real system or in hasher with network).

%files under-pkdirect-checkinstall
%dir %_datadir/%name
%_datadir/%name/run-tests-dir
%_datadir/%name/tests-under-pkdirect

%post under-pkdirect-checkinstall
# so that the two outputs are not out of sync
exec 1>&2

%_datadir/%name/run-tests-dir %_datadir/%name/tests-under-pkdirect

# * * *
#
# Note that git-bisect(1) expects an "exit with a code between 1 and
# 127 (inclusive), except 125, if the current source code is bad".
# Therefore, I suggest to use this test script (or the wrapper
# ./test-pk-in-hsh.sh) like this:
#
#   cd apt
#   git bisect start --no-checkout PK-BAD PK-GOOD
#   git bisect run /bin/sh -exc './gear-build-pair-in-hsh.sh . BISECT_HEAD ../packagekit/ revert-apt-API ~/hasher/; hsh-install ~/hasher/ apt-under-pkdirect-checkinstall || { echo BAD: $?; exit 1; }'


%files -f %name.lang
%_bindir/apt-*
%_libexecdir/apt
%_libdir/%name
%exclude %_libdir/%name/methods/rsync
%exclude %_libdir/%name/methods/https
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/%name.conf
%dir %_sysconfdir/%name/*.d
%config(noreplace) %_sysconfdir/%name/%name.conf.d/01-Debug-pkgMarkInstall.conf
%config(noreplace) %_sysconfdir/%name/%name.conf.d/01-Debug-Acquire.conf
%config(noreplace) %_sysconfdir/%name/%name.conf.d/01-UI.conf
%_mandir/man?/*
%doc README* TODO COPYING AUTHORS* ChangeLog-rpm.old.bz2 doc/examples contrib

%defattr(2770,root,rpm,2770)
%_cachedir/%name/archives

%files -n libapt
%_libdir/*.so.*
%_localstatedir/%name

%defattr(2770,root,rpm,2770)
%dir %_cachedir/%name

%files -n libapt-devel
%_libdir/*.so
%_includedir/*

%if_enabled static
%files -n libapt-devel-static
%_libdir/*.a
%endif

%files rsync
%dir %_libdir/%name
%dir %_libdir/%name/methods
%_libdir/%name/methods/rsync
# Probably %%doc with README.rsync?

%files https
%dir %_libdir/%name
%dir %_libdir/%name/methods
%_libdir/%name/methods/https

%files tests
%dir %_datadir/%name
%_datadir/%name/tests/

%changelog
