%define _unpackaged_files_terminate_build 1
%def_disable static
%def_without bootstrap
%def_with ldap

Name: audit
Version: 4.0.5
Release: alt1

Summary: User space tools for Linux kernel 2.6+ auditing
License: GPL-2.0-or-later and LGPL-2.1-or-later
Group: Monitoring

URL: https://people.redhat.com/sgrubb/audit
VCS: https://github.com/linux-audit/audit-userspace

Source: %name-%version.tar
Patch0: %name-%version-alt.patch

Requires: libaudit1 = %EVR

# Make audit installable on systems without systemd
# (upstream dropped support for SysVinit since 4.0)
%filter_from_requires /^\/bin\/systemctl$/d
%add_findreq_skiplist %_initdir/auditd

%if_without bootstrap
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-setuptools

BuildRequires: swig
BuildRequires: automake
BuildRequires: perl-XML-Parser
BuildRequires: libkrb5-devel
BuildRequires: libcap-ng-devel
%endif

%if_enabled static
BuildRequires: glibc-devel-static
%endif

%if_with ldap
BuildRequires: libldap-devel
%endif

%description
The audit package contains the user space utilities for
storing and searching the audit records generate by
the audit subsystem in the Linux 2.6+ kernel.

%package -n libaudit1
Summary: Dynamic library for audit framework
License: LGPL-2.1-or-later
Group: System/Libraries
Provides: libaudit = %EVR
Obsoletes: libaudit = 2.0.4-alt1

%description -n libaudit1
This package contains the dynamic libraries needed for
applications to use the audit framework.

%package -n libauparse0
Summary: Dynamic library for audit framework
License: LGPL-2.1-or-later
Group: System/Libraries
Conflicts: libaudit = 2.0.4-alt1
Conflicts: libaudit < 1.7.16-alt2

%description -n libauparse0
This package contains the dynamic libraries needed for
applications to use the audit framework.

%package -n libaudit-devel
Summary: Header files and static library for libaudit
License: LGPL-2.1-or-later
Group: Development/C
Requires: libaudit1 = %EVR
Requires: libauparse0 = %EVR

%description -n libaudit-devel
This package contains the static libraries and header
files needed for developing applications that need to use the audit
framework libraries.

%package -n python3-module-audit
Summary: Python3 bindings for libaudit
License: LGPL-2.1-or-later
Group: Development/Python3
Requires: libaudit1 = %EVR

%description -n python3-module-audit
The python3-module-audit package contains the bindings so that libaudit
and libauparse can be used by python.

%prep
%setup
%patch0 -p1

# set initdir to _unitdir for compatibility with usr-merged systems
sed -i 's|^initdir = .*|initdir = %_unitdir|' init.d/Makefile.am

# correct sbindir in init scripts
sed -i 's|/sbin/auditctl|%_sbindir/auditctl|' init.d/*

# workaround automake strictness settings
touch README

%build
export PYTHON=python3
export PYTHON3=python3
%autoreconf

%configure \
	--sbindir=%_sbindir \
	--libdir=%_libdir \
	--libexecdir=%prefix/libexec \
	--with-aarch64 \
	--with-arm \
	--with-libcap-ng=yes \
	--without-golang \
	--enable-experimental \
	--with-io_uring \
%if_with bootstrap
	--without-python3 \
%else
	--enable-gssapi-krb5 \
%endif
%if_without ldap
	--disable-zos-remote \
%endif
	%{subst_enable static}

%make_build

%install
export PYTHON=python3
export PYTHON3=python3
%makeinstall_std

install -d %buildroot%_logdir/audit
install -d %buildroot%_libdir/audit

install -pD -m644 rules/10-base-config.rules \
        %buildroot%_sysconfdir/audit/rules.d/10-base-config.rules

install -Dpm755 audit.init %buildroot/%_initdir/auditd

%check
export PYTHON=python3
export PYTHON3=python3
%make check

%post
%post_service auditd
if [ $1 -gt 1 ]; then
    service auditd condrestart ||:
fi

%preun
%preun_service auditd
if [ $1 -eq 0 ]; then
    service auditd stop ||:
fi

%files
%doc README.md ChangeLog contrib init.d/auditd.cron
%_bindir/aulastlog
%_bindir/aulast
%_bindir/ausyscall
%_sbindir/ausearch
%_sbindir/aureport
%attr(750,root,root) %_sbindir/auditctl
%attr(750,root,root) %_sbindir/augenrules
%attr(750,root,root) %_sbindir/auditd
%attr(750,root,root) %_sbindir/audisp-af_unix
%attr(750,root,root) %_sbindir/audisp-filter
%attr(750,root,root) %_sbindir/audisp-ids
%attr(750,root,root) %_sbindir/audisp-remote
%attr(750,root,root) %_sbindir/audisp-statsd
%attr(750,root,root) %_sbindir/audisp-syslog
%if_with ldap
%attr(750,root,root) %_sbindir/audispd-zos-remote
%endif

%_initdir/auditd

%attr(700,root,root) %_logdir/audit
%_unitdir/auditd.service
%_unitdir/audit-rules.service
%_tmpfilesdir/audit.conf

%_datadir/audit-rules
%_man5dir/*
%_man8dir/*
%_man7dir/*

%attr(700,root,root) %dir %_sysconfdir/audit
%config(noreplace) %attr(600,root,root) %_sysconfdir/audit/auditd.conf
%config(noreplace) %attr(600,root,root) %_sysconfdir/audit/audit-stop.rules

%attr(700,root,root) %dir %_sysconfdir/audit/rules.d
%config(noreplace) %attr(600,root,root) %_sysconfdir/audit/rules.d/*.rules

%attr(700,root,root) %dir %_sysconfdir/audit/plugins.d
%config(noreplace) %attr(640,root,root) %_sysconfdir/audit/plugins.d/*.conf

%config(noreplace) %attr(640,root,root) %_sysconfdir/audit/audisp-remote.conf
%config(noreplace) %attr(640,root,root) %_sysconfdir/audit/zos-remote.conf
%config(noreplace) %attr(640,root,root) %_sysconfdir/audit/ids.conf
%config(noreplace) %attr(640,root,root) %_sysconfdir/audit/audisp-statsd.conf
%config(noreplace) %attr(640,root,root) %_sysconfdir/audit/audisp-filter.conf

/usr/libexec/service/legacy-actions/auditd

%files -n libaudit1
%_libdir/libaudit.so.*
%config(noreplace) %attr(600,root,root) %_sysconfdir/libaudit.conf

%files -n libauparse0
%_libdir/libauparse.so.*

%files -n libaudit-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*
%_man3dir/*
%_aclocaldir/audit.m4

%if_without bootstrap
%files -n python3-module-audit
%python3_sitelibdir/audit.py
%python3_sitelibdir/_audit.la
%python3_sitelibdir/_audit.so
%python3_sitelibdir/auparse.la
%python3_sitelibdir/auparse.so
%python3_sitelibdir/__pycache__/*
%endif

%changelog
