%define _unpackaged_files_terminate_build 1

# To run the database build test the clickhouse-server package
# is needed.
%ifarch x86_64 aarch64
%def_with dbtest
%else
%def_without dbtest
%endif

Name:    auditd-plugin-clickhouse-lite
Version: 0.1.8
Release: alt2
Summary: A lightweight plugin for auditd daemon to send audit data to a Clickhouse database
Group:   Monitoring
License: GPLv3+

Source: %name-%version.tar

BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc-c++ cmake
BuildRequires: boost-complete
BuildRequires: libclickhouse-cpp-devel
BuildRequires: libaudit-devel
BuildRequires: bats /proc

%if_with dbtest
BuildRequires: pytest3 python3(clickhouse_test) clickhouse-server
BuildRequires: python3(clickhouse_driver)
%endif

# audit 3.0 has changed the location for configs
Requires: audit >= 3.0-alt1

%description
A lightweight plugin for auditd daemon to send audit data to a Clickhouse
database.

%package -n clickhouse-audit-utils
Summary: Utilities to work with audit data stored in a Clickhouse database
Group:   Monitoring
License: GPLv3+

%description -n clickhouse-audit-utils
Utilities to work with audit data stored in a Clickhouse database.
Currently the package contains only the export script that could be
used to export the database records back to text (log) files.

%prep
%setup

%build
%add_optflags -Werror
%cmake
%cmake_build

%install
%cmake_install

install -D -m0755 clickhouse-audit-export \
		%buildroot/%_bindir/clickhouse-audit-export

%check
CLICKHOUSE_SERVER_CLEANUP=1 BUILD=%_cmake__builddir \
    ./run-tests.sh normal \
                   chunked \
		   bench \
%if_with dbtest
		   db
%endif

%files
%_prefix/libexec/%name
%dir %_datadir/%name
%_datadir/%name/init_db.sql
%config(noreplace) %attr(600,root,root) %_sysconfdir/audit/%name.conf
%config(noreplace) %_sysconfdir/audit/plugins.d/clickhouse-lite.conf
%config(noreplace) %_sysconfdir/logrotate.d/%name-logrotate.conf

%files -n clickhouse-audit-utils
%_bindir/clickhouse-audit-export

%changelog
