%define soname 3
%def_with pstoedit
%def_disable static
%def_disable magick
%define pstoedit_ver 3.32

Name: autotrace
Version: 0.31.10
Release: alt2

Summary: Bitmap to vector graphics converter
Summary(ru_RU.UTF-8): Программа трассировки растровых изображений.
Group: Graphics
License: GPLv2+ and LGPLv2+
Url: https://github.com/autotrace/autotrace
Source: %name-%version.tar
Patch0: %name-%version-%release.patch
%if_with pstoedit
BuildPreReq: libpstoedit-devel >= %pstoedit_ver
%endif
BuildRequires: libImageMagick-devel libpng-devel
BuildRequires: glib2-devel
BuildRequires: gettext-devel
BuildRequires: libstdc++-devel
BuildRequires: intltool

%description
The aim of the AutoTrace project is the development of a freely
available application with a functionality similar to CorelTrace or
Adobe Streamline. I hope that it will become better than all
commercially available programs. In some aspects it is already better.

Supported formats:
Input BMP, TGA, PNM, PPM, PGM, PBM and those supported by ImageMagick.
Export Postscript, svg, xfig, swf, pstoedit, emf, dxf, cgm, mif, p2e and sk

%description -l ru_RU.UTF-8
%name - программа преобразования растровых изображений в векторные.

Поддерживаемые форматы:
Растровые: BMP, TGA, PNM, PPM, PGM, PBM и прочие, поддерживаемые программой ImageMagick.
Векторные: Postscript, svg, xfig, swf, pstoedit, emf, dxf, cgm, mif, p2e и sk

%package -n lib%name%soname
Summary: Shared library for %name
Group: System/Libraries

%description -n lib%name%soname
Shared library needed to run %name.

%package -n lib%name-devel
Summary: Development package of %name
Group: Development/C
Requires: lib%name%soname = %EVR
Requires: libImageMagick-devel
%if_with pstoedit
Requires: libpstoedit-devel >= %pstoedit_ver
%endif

%description -n lib%name-devel
Headers files needed to compile programs using lib%name.

%package -n lib%name-devel-static
Summary: Static version of lib%name
Group: System/Libraries
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
This package contains static library required for packaging statically
linked software using lib%name.

%prep
%setup
%patch0 -p1

%build
autoreconf -fisv
%configure \
	%{subst_enable static} \
	%{subst_enable magick} \
%if_without pstoedit
	--without-pstoedit
%endif
	%nil

%make_build

%install
%makeinstall

%find_lang %name

%files -f %name.lang
%doc README* NEWS AUTHORS ChangeLog THANKS
%_bindir/%name
%_man1dir/*

%files -n lib%name%soname
%_libdir/*.so.%soname
%_libdir/*.so.%soname.*

%files -n lib%name-devel
%_includedir/%name
%_libdir/*.so
%_libdir/pkgconfig/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
