%define _unpackaged_files_terminate_build 1
%define _libexecdir %_prefix/libexec

%define libname libmessaging-menu
%define typelib %libname-gir
%define sover   0
Name: ayatana-indicator-messages
Version: 24.5.0
Release: alt1

Summary: Ayatana Indicator for collecting messages that need a response
License: GPLv3
Group: Graphical desktop/Other
Url: https://github.com/AyatanaIndicators/ayatana-indicator-messages

Source: %name-%version.tar

ExcludeArch: ppc64le

BuildRequires(pre): rpm-build-vala
BuildRequires(pre): rpm-macros-cmake
BuildRequires(pre): rpm-macros-systemd

BuildRequires: ayatana-cmake-modules
BuildRequires: ayatana-indicator-common
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: gobject-introspection-devel
BuildRequires: gtk-doc
BuildRequires: hicolor-icon-theme
BuildRequires: intltool
BuildRequires: libaccountsservice-devel
BuildRequires: libblkid-devel
BuildRequires: libffi-devel
BuildRequires: libmount-devel
BuildRequires: libpcre2-devel
BuildRequires: libpcre-devel
BuildRequires: libpolkit-devel
BuildRequires: libselinux-devel
BuildRequires: libsystemd-devel
BuildRequires: pkg-config
BuildRequires: vala
BuildRequires: vala-tools
BuildRequires: zlib-devel

Requires: ayatana-indicator-common
Requires: gobject-introspection
Requires: typelib(MessagingMenu)
Requires: %libname%sover

%description
A place on the user's desktop that collects messages that need a
response. This menu provides a condensed and collected view of all
of those messages for quick access, but without making them
annoying in times that you want to ignore them.

%package -n %libname%sover
Summary: Shared library for providing status information to the messaging indicator
Group: System/Libraries

%description -n %libname%sover
A place on the user's desktop that collects messages that need a
response. This menu provides a condensed and collected view of all
of those messages for quick access, but without making them
annoying in times that you want to ignore them.

%package -n %libname-devel
Summary: Development files for Ayatana Messaging Menu
Group: Development/C
Requires: %libname%sover = %version

%description -n %libname-devel
A place on the user's desktop that collects messages that need a
response. This menu provides a condensed and collected view of all
of those messages for quick access, but without making them
annoying in times that you want to ignore them.

%package -n %libname-doc
Group: Documentation
Summary: HTML documentation for the Ayatana Messaging Indicator shared library
BuildArch: noarch

%description -n %libname-doc
This package installs documentation for the Ayatana Messaging
Indicator shared library.

%package -n %typelib
Summary: Ayatana Messaging indicators library
Group: System/Libraries

%description -n %typelib
This package contains the GObject Introspection bindings for the
Ayatana Messaging Menu library.

%prep
%setup

%build
%cmake \
  -Denable_tests=Off
%cmake_build

%install
%cmake_install
find %buildroot -type f -name "*.la" -delete -print

# these translations are ignored by %%find_lang
rm -fv %buildroot%_datadir/locale/it_CARES/LC_MESSAGES/%name.mo
rm -fv %buildroot%_datadir/locale/zh_LATN@pinyin/LC_MESSAGES/%name.mo

%find_lang %name

%post
%systemd_user_post %name.service

%preun
%systemd_user_preun %name.service

%postun
%systemd_user_postun %name.service

%files -f %name.lang
%doc COPYING NEWS
%config %_sysconfdir/xdg/autostart/%name.desktop
%dir %_libexecdir/%name/
%_libexecdir/%name/%{name}-service
%_datadir/ayatana/indicators/org.ayatana.indicator.messages
%_datadir/glib-2.0/schemas/org.ayatana.indicator.messages.gschema.xml
%_iconsdir/hicolor/*/*/*
%_userunitdir/%name.service

%files -n %libname%sover
%_libdir/libmessaging-menu.so.%{sover}*

%files -n %libname-devel
%_includedir/messaging-menu/
%_datadir/gir-1.0/MessagingMenu-1.0.gir
%_vapidir/MessagingMenu-1.0.vapi
%_libdir/libmessaging-menu.so
%_pkgconfigdir/messaging-menu.pc

%files -n %libname-doc
%dir %_datadir/gtk-doc/html/messaging-menu
%_datadir/gtk-doc/html/messaging-menu/*

%files -n %typelib
%_libdir/girepository-1.0/MessagingMenu-1.0.typelib

%changelog
