%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%define mpiimpl openmpi
%define mpidir %_libdir/%mpiimpl

%def_without python

Name: babel
Version: 2.0.0
Release: alt7
Summary: Language tool for high-performance scientific computing community
License: LGPLv2.1
Group: Sciences/Mathematics
Url: http://www.llnl.gov/CASC/components/babel.html

Source: %name-%version.tar

Requires: %name-common = %EVR
Requires: lib%name = %EVR
Requires: lib%name-devel = %EVR
Requires: %name-j = %EVR
%if_with python
Requires: python-module-sidl = %EVR
Requires: python-module-sidlx = %EVR
%endif

Conflicts: openbabel

BuildRequires(pre): rpm-build-compat rpm-build-python
BuildRequires: gcc-c++ %mpiimpl-devel libltdl7-devel
BuildRequires: libxml2-devel libparsifal-devel
BuildRequires: jpackage-utils gnu-getopt
%ifnarch %e2k
BuildRequires: gcc-fortran
%endif
%if_with python
BuildRequires: python-devel libnumpy-devel
%endif
BuildRequires: /proc chrpath
%if "%version" == "2.0.0"
# old version requires old java
BuildRequires: jpackage-1.8-compat
%else
# when update to babel 3.x, use modern java compiler
BuildRequires: jpackage-default
%endif


%description
  Babel is a language interoperability tool intended for use by
the high-performance scientific computing community.  Developed
by the Components project (http://www.llnl.gov/CASC/components)
at Lawrence Livermore National Laboratory, Babel supports the
Scientific Interface Definition Language (SIDL) for the language-
independent declaration of interfaces associated with scientific
software packages.

  The Babel tool, applied to a SIDL file, results in the automatic
generation of the associated skeleton and stub source files.  The
Babel user then need only add the necessary code to the _Impl source
files to complete the provision of a language-independent interface
to the package described by the SIDL file.  The languages currently
supported by Babel are C, C++, F77, F90, Java and Python.  

This package contains main compiler files. Conflicts with Open Babel, because
contains another file named 'babel' in /usr/bin.

%package -n lib%name
Summary: Shared libraries of Babel
Group: System/Libraries

%description -n lib%name
  Babel is a language interoperability tool intended for use by
the high-performance scientific computing community.  Developed
by the Components project (http://www.llnl.gov/CASC/components)
at Lawrence Livermore National Laboratory, Babel supports the
Scientific Interface Definition Language (SIDL) for the language-
independent declaration of interfaces associated with scientific
software packages.

  The Babel tool, applied to a SIDL file, results in the automatic
generation of the associated skeleton and stub source files.  The
Babel user then need only add the necessary code to the _Impl source
files to complete the provision of a language-independent interface
to the package described by the SIDL file.  The languages currently
supported by Babel are C, C++, F77, F90, Java and Python.  

This package contains shared libraries of Babel.

%package -n lib%name-devel
Summary: Development files for Babel
Group: Development/Other
Requires: %name = %EVR
Requires: %name-common = %EVR
Requires: lib%name = %EVR
Requires: %name-j = %EVR
%if_with python
Requires: python-module-sidl = %EVR
%endif

%description -n lib%name-devel
  Babel is a language interoperability tool intended for use by
the high-performance scientific computing community.  Developed
by the Components project (http://www.llnl.gov/CASC/components)
at Lawrence Livermore National Laboratory, Babel supports the
Scientific Interface Definition Language (SIDL) for the language-
independent declaration of interfaces associated with scientific
software packages.

  The Babel tool, applied to a SIDL file, results in the automatic
generation of the associated skeleton and stub source files.  The
Babel user then need only add the necessary code to the _Impl source
files to complete the provision of a language-independent interface
to the package described by the SIDL file.  The languages currently
supported by Babel are C, C++, F77, F90, Java and Python.  

This package contains development files for Babel.

%package -n python-module-sidl
Summary: Build Python support extension modules for sidl
Group: Development/Python
Requires: lib%name = %EVR
%setup_python_module sidl

%description -n python-module-sidl
  Babel is a language interoperability tool intended for use by
the high-performance scientific computing community.  Developed
by the Components project (http://www.llnl.gov/CASC/components)
at Lawrence Livermore National Laboratory, Babel supports the
Scientific Interface Definition Language (SIDL) for the language-
independent declaration of interfaces associated with scientific
software packages.

  The Babel tool, applied to a SIDL file, results in the automatic
generation of the associated skeleton and stub source files.  The
Babel user then need only add the necessary code to the _Impl source
files to complete the provision of a language-independent interface
to the package described by the SIDL file.  The languages currently
supported by Babel are C, C++, F77, F90, Java and Python.  

This package contains python support extension modules for sidl.

%package -n python-module-sidlx
Summary: Build Python support experimental extension modules for sidl
Group: Development/Python
Requires: lib%name = %EVR
%setup_python_module sidlx

%description -n python-module-sidlx
  Babel is a language interoperability tool intended for use by
the high-performance scientific computing community.  Developed
by the Components project (http://www.llnl.gov/CASC/components)
at Lawrence Livermore National Laboratory, Babel supports the
Scientific Interface Definition Language (SIDL) for the language-
independent declaration of interfaces associated with scientific
software packages.

  The Babel tool, applied to a SIDL file, results in the automatic
generation of the associated skeleton and stub source files.  The
Babel user then need only add the necessary code to the _Impl source
files to complete the provision of a language-independent interface
to the package described by the SIDL file.  The languages currently
supported by Babel are C, C++, F77, F90, Java and Python.  

This package contains python support experimental extension modules for sidl.

%package j
Summary: Babel java packages
Group: Development/Java
BuildArch: noarch
Requires: lib%name = %EVR
Requires: java >= 1.5.0

%description j
  Babel is a language interoperability tool intended for use by
the high-performance scientific computing community.  Developed
by the Components project (http://www.llnl.gov/CASC/components)
at Lawrence Livermore National Laboratory, Babel supports the
Scientific Interface Definition Language (SIDL) for the language-
independent declaration of interfaces associated with scientific
software packages.

  The Babel tool, applied to a SIDL file, results in the automatic
generation of the associated skeleton and stub source files.  The
Babel user then need only add the necessary code to the _Impl source
files to complete the provision of a language-independent interface
to the package described by the SIDL file.  The languages currently
supported by Babel are C, C++, F77, F90, Java and Python.  

This package contains Babel java packages.

%package common
Summary: Babel common files
Group: Development/Other
BuildArch: noarch

%description common
  Babel is a language interoperability tool intended for use by
the high-performance scientific computing community.  Developed
by the Components project (http://www.llnl.gov/CASC/components)
at Lawrence Livermore National Laboratory, Babel supports the
Scientific Interface Definition Language (SIDL) for the language-
independent declaration of interfaces associated with scientific
software packages.

  The Babel tool, applied to a SIDL file, results in the automatic
generation of the associated skeleton and stub source files.  The
Babel user then need only add the necessary code to the _Impl source
files to complete the provision of a language-independent interface
to the package described by the SIDL file.  The languages currently
supported by Babel are C, C++, F77, F90, Java and Python.  

This package contains Babel common files.

%package javadoc
Summary: Javadoc for Babel
Group: Development/Documentation
BuildArch: noarch

%description javadoc
  Babel is a language interoperability tool intended for use by
the high-performance scientific computing community.  Developed
by the Components project (http://www.llnl.gov/CASC/components)
at Lawrence Livermore National Laboratory, Babel supports the
Scientific Interface Definition Language (SIDL) for the language-
independent declaration of interfaces associated with scientific
software packages.

  The Babel tool, applied to a SIDL file, results in the automatic
generation of the associated skeleton and stub source files.  The
Babel user then need only add the necessary code to the _Impl source
files to complete the provision of a language-independent interface
to the package described by the SIDL file.  The languages currently
supported by Babel are C, C++, F77, F90, Java and Python.  

This package contains Javadoc for Babel.

%package manual
Summary: User manual for Babel
Group: Development/Documentation
BuildArch: noarch

%description manual
  Babel is a language interoperability tool intended for use by
the high-performance scientific computing community.  Developed
by the Components project (http://www.llnl.gov/CASC/components)
at Lawrence Livermore National Laboratory, Babel supports the
Scientific Interface Definition Language (SIDL) for the language-
independent declaration of interfaces associated with scientific
software packages.

  The Babel tool, applied to a SIDL file, results in the automatic
generation of the associated skeleton and stub source files.  The
Babel user then need only add the necessary code to the _Impl source
files to complete the provision of a language-independent interface
to the package described by the SIDL file.  The languages currently
supported by Babel are C, C++, F77, F90, Java and Python.  

This package contains user manual for Babel.


%prep
%setup
find -name Makefile.in -exec sed 's/-traditional/& -Ubool -Uvector/' -i {} \;

%build
%add_optflags -D_FILE_OFFSET_BITS=64
%add_optflags -std=c++14

export JAVAPREFIX="%_libexecdir/jvm/java"
export CLASSPATH=".:$(build-classpath gnu-getopt):$(pwd)/compiler"
export JAVACFLAGS="-classpath $CLASSPATH"
export JAVAFLAGS=""
export MPI_VENDOR=%mpiimpl
source %mpidir/bin/mpivars.sh

%ifnarch %e2k
# unsupported as of lcc 1.25.17 (mcst#6419); NB: fortran-only
%add_optflags -fallow-argument-mismatch
%endif
%configure \
	--enable-pure-static-runtime=no \
	--enable-static=no \
	--with-gnu-ld \
%ifarch %e2k
	--disable-fortran90 \
	--disable-fortran03 \
	--disable-fortran77 \
%else
	--with-F90-vendor=GNU \
%endif
	--with-libparsifal=%prefix \
	--with-libxml2=%prefix \
	--with-mpi=%mpidir/bin \
	--with-ltdl-lib=%_libdir \
	--with-ltdl-include=%_includedir \
	%{subst_with python} \
	--enable-java=$JAVAPREFIX

%install
source %mpidir/bin/mpivars.sh
%make_build
touch bin/revision.txt
%makeinstall_std

rm -f %buildroot%_includedir/c
install -d %buildroot%_includedir/c

# fix bin files

sed -i \
	-e 's/^\(JAVA\)\=.*/\1="java"/' \
	-e 's/^\(is_installed\)\=.*/\1="true"/' \
	-e 's/xerces\-2\.9\.1/xerces-j2/g' \
	-e 's/\-I\ /-I. /g' \
	-e 's/\-I\"/-I."/g' \
	%buildroot%_bindir/babel*
sed -i 's|\${prefix}/lib|%_javadir|g' %buildroot%_bindir/babel*

install -d %buildroot%_docdir/%name
mv %buildroot%_docdir/%name-%version/* %buildroot%_docdir/%name/

# rename conflicted files

mv %buildroot%_datadir/aclocal/libtool.m4 \
	%buildroot%_datadir/aclocal/libtool-%name.m4
mv %buildroot%_datadir/aclocal/ltdl.m4 \
	%buildroot%_datadir/aclocal/ltdl-%name.m4

# prepare libs

install -d %buildroot%_javadir
pushd %buildroot%_libexecdir
rm -f xerces* xalan.*
mv LICENSE-SAX.html java-getopt.INFO java-getopt.LICENSE $OLDPWD/
mv *.jar %buildroot%_javadir/
popd

# javadoc

install -d %buildroot%_javadocdir/%name-%version
mv %buildroot%_docdir/%name/compiler-javadoc \
	%buildroot%_javadocdir/%name-%version/

sed -i -e 's/^\(predep_objects\|postdep_objects\|compiler_lib_search_path\)=.*/\1=""/' \
       -e 's/^\(archive\(_expsym\)\?_cmds=\".*\) -nostdlib /\1 /' \
	%buildroot%_bindir/%name-libtool
out="\$(\$CC -print-search-dirs |\$SED -e '/^libraries: *=/!d;s///;s!/:!:!g;s!/\$!!;s/:/ /g')"
sed -i 's#^\(compiler_lib_search_dirs="\)/.*#\1'"$out"'"#' \
	%buildroot%_bindir/%name-libtool

sed -i 's|%buildroot||' %buildroot%_libdir/libsidl*.scl

for i in %buildroot%_libdir/*.so
do
	chrpath -d $i ||:
done

%files
%doc ANNOUNCE BUGS CHANGES COPYRIGHT LICENSE README THANKS
%_bindir/*
%_man1dir/*

%files -n lib%name
%_libdir/*-%version.so

%files -n lib%name-devel
#doc DEVELOPER.README HOWTO_RELEASE_PATCH.html coding_standards.html
%_includedir/*
%_libdir/*.so
%exclude %_libdir/*-%version.so
%_libdir/*.scl
%_aclocaldir/*
%_pkgconfigdir/*

%if_with python
%files -n python-module-sidl
%python_sitelibdir/llnl_babel-*
%python_sitelibdir/sidl*
%exclude %python_sitelibdir/sidlx*

%files -n python-module-sidlx
%python_sitelibdir/llnl_babel_sidl_sidlx-*
%python_sitelibdir/sidlx*
%endif

%files j
%_javadir/*

%files common
%_datadir/*.sidl
%_datadir/%name-runtime-%version
%_datadir/%name-%version
%dir %_datadir/sgml
%_datadir/sgml/%name-%version

%files javadoc
%_javadocdir/*

%files manual
%_docdir/%name

%changelog
