Name: basesystem
Version: sisyphus
Release: alt25
Epoch: 1

Summary: The skeleton package which defines a basic %distribution chroot
License: GPLv2+
Group: System/Base
BuildArch: noarch

Requires: altlinux-release
Requires: bash
Requires: common-licenses
Requires: etcskel
Requires: filesystem
Requires: gawk
Requires: getopt
Requires: gzip
Requires: perl-base
Requires: rootfiles
Requires: rpm
Requires: setup
Requires: shadow-utils
Requires: tar
Requires: util-linux
Requires: vitmp
Requires: xz
Requires: zstd

%description
This package defines the components of a basic %distribution system
(for example, the package installation order to use during bootstrapping).

%files

%post
# Upgrade passwd manually, until we gain an independent implementation
# of sysusers.
# Enforce UID and GID change for `nobody'; https://altlinux.org/NobodySubjectPolicy
line="$(grep ^nobody /etc/passwd)"
[ "${line#*:*:65534:65534:}" != "$line" ] || {
	script='
BEGIN {
	FS = ":"; OFS = ":";
}
{
	if ($1 == "nobody") {
		$1 = "nobody";
		if ($2 != "*") {
			$2 = "x";
		}
		$3 = "65534";
		$4 = "65534";
		$5 = "Linux Kernel overflowuid";
		$6 = "/dev/null";
		$7 = "/dev/null";
		NF = 7;
	}
	print;
}
'
	awk "$script" /etc/passwd > /etc/passwd.new
	mv /etc/passwd.new /etc/passwd

	script='
BEGIN {
	FS = ":"; OFS = ":";
}
{
	if ($1 == "nobody") {
		$1 = "nobody";
		$2 = "x";
		$3 = "65534";
		NF = 4;
	}
	print;
}
'
	awk "$script" /etc/group > /etc/group.new
	mv /etc/group.new /etc/group
}

%changelog
