%define _unpackaged_files_terminate_build 1

# build rules
%def_without docs
%def_with openssl
%def_with libjson
%def_with libjemalloc
%def_with check
%def_without system_tests
# skip enginepkcs11 tests
# https://github.com/openssl/openssl/issues/22508
%def_with enginepkcs11

# common directory for documentation
%define docdir %_docdir/bind-%version
# root directory for chrooted environment
%define _chrootdir %_localstatedir/bind
%define run_dir /run/named
%define log_dir %_logdir/named
%define restart_flag /run/named/named.restart

%define named_user named
%define named_group named

%ifndef timestamp
%define timestamp %(TZ=UTC LC_TIME=C date +%%Y%%m%%d)
%endif

Name: bind
Version: 9.18.39
%define src_version 9.18.39
Release: alt1

Summary: ISC BIND - DNS server
License: MPL-2.0
Group: System/Servers
Url: https://www.isc.org/bind/
VCS: https://gitlab.isc.org/isc-projects/bind9.git

# ftp://ftp.isc.org/isc/bind9/%src_version/bind-%src_version.tar.xz
Source0: %name-%version.tar
Source3: README.bind-devel
Source4: README.ALT

Source11: bind.init

Source21: rndc.conf
Source22: rndc.key

Source31: bind.named.conf
Source32: bind.options.conf
Source33: bind.rndc.conf
Source34: bind.local.conf
Source35: bind.rfc1912.conf
Source36: bind.rfc1918.conf
Source37: bind.sysconfig

Source41: bind.localhost
Source42: bind.localdomain
Source43: bind.127.in-addr.arpa
Source44: bind.empty

Source50: bind.service
Source51: bind.tmpfiles.conf

# NB: there must be at least one patch :)
Patch0001: 0001-ALT-defaults-Reintroduce-chrooted-named-by-default.patch
Patch0002: 0002-ALT-Minimize-linux-capabilities.patch
Patch0003: 0003-ALT-Make-it-possible-to-retain-Linux-capabilities-of.patch
Patch0004: 0004-ALT-named-Allow-non-writable-working-directory.patch
Patch0005: 0005-ALT-tests-Unchroot-named-for-tests.patch
Patch0007: 0007-ALT-tests-Raise-expected-delta-time-for-cds.patch
Patch0009: 0009-ALT-tests-Avoid-socket-creation-on-9pfs.patch
Patch0010: 0010-ALT-tests-Handle-unset-TSAN_OPTIONS.patch

%if_with docs
BuildRequires: python3(sphinx)
BuildRequires: python3(sphinx_rtd_theme)
%endif

%if_with check
# for backtraces
BuildRequires: gdb
BuildRequires: python3-module-dnspython
%if_with system_tests
BuildRequires: python3(hypothesis)
# /usr/bin/gnutls-cli is required by doth tests
BuildRequires: gnutls-utils
# taskset is required by cpu tests
BuildRequires: schedutils
%if_with enginepkcs11
# requires only for pkcs11 tests
BuildRequires: softhsm
BuildRequires: libp11
BuildRequires: opensc
BuildRequires: openssl
%endif
%else
BuildRequires: rpm-build-vm
BuildRequires: /dev/kvm
%endif

BuildRequires: iproute2
BuildRequires: perl-Net-DNS
BuildRequires: perl-File-Fetch
BuildRequires: perl-Digest-HMAC
BuildRequires: python3(pytest)
%endif

Provides: bind-chroot(%_chrootdir)
Obsoletes: bind-chroot, bind-debug, bind-slave, caching-nameserver
# Because of /etc/syslog.d/ feature.
Conflicts: syslogd < 1.4.1-alt11
Requires(pre): bind-control >= 1.3

# due to %_chrootdir/dev/log
BuildPreReq: coreutils

# due to broken configure script
BuildPreReq: gcc-c++

# for better --enable-linux-caps experience
BuildPreReq: libcap-devel

%{?_with_openssl:BuildPreReq: libssl-devel}
%{?_with_libjson:BuildPreReq: libjson-c-devel}
%{?_with_libjemalloc:BuildRequires: libjemalloc-devel}
BuildPreReq: libkrb5-devel
BuildRequires: libuv-devel
BuildRequires: libidn2-devel
# doh support
BuildRequires: libnghttp2-devel

%package utils
Summary: Utilities provided by ISC BIND
Group: Networking/Other
Requires: libbind = %EVR

%package -n libbind
Summary: Shared library used by ISC BIND
Group: System/Libraries
Provides: libdns = %EVR
Provides: libisc = %EVR
Provides: libisccc = %EVR
Provides: libisccfg = %EVR
Obsoletes: libdns8, libdns9, libdns10, libdns11, libdns16
Obsoletes: libisc4, libisc7, libisccc0, libisccfg0

%package devel
Summary: ISC BIND development libraries and headers
Group: Development/C
Requires: libbind = %EVR
Provides: libisc-export-devel = %EVR
Obsoletes: libisc-export-devel < %version

%if_with docs
%package doc
Summary: Documentation for ISC BIND
Group: Development/Other
BuildArch: noarch
Prefix: %prefix
%endif

%description
The Berkeley Internet Name Domain (BIND) implements an Internet domain
name server.  BIND is the most widely-used name server software on the
Internet, and is supported by the Internet Software Consortium (ISC).

This package provides the %src_version server and related
configuration files.

%description utils
This package contains various utilities related to DNS that are derived
from the BIND %src_version source tree, including dig, host,
nslookup and nsupdate.

%description -n libbind
This package contains shared libraries used by BIND's %src_version
daemons and clients.

%description devel
This package contains development libraries, header files, and API man
pages for libdns, libisc, libisccc, libisccfg. These are
only needed if you want to compile packages that need more BIND
%src_version nameserver API than the resolver code provided by
glibc.

%if_with docs
%description doc
This package provides various documents that are useful for maintaining
a working BIND %src_version installation.
%endif

%prep
%setup

# NB: there must be at least one patch :)
%autopatch -p2

mkdir addon
install -pm644 \
    %_sourcedir/bind.init \
    %_sourcedir/bind.named.conf \
    %_sourcedir/bind.options.conf \
    %_sourcedir/bind.rndc.conf \
    %_sourcedir/bind.local.conf \
    %_sourcedir/bind.rfc1912.conf \
    %_sourcedir/bind.rfc1918.conf \
    %_sourcedir/bind.localhost \
    %_sourcedir/bind.localdomain \
    %_sourcedir/bind.127.in-addr.arpa \
    %_sourcedir/bind.empty \
    %_sourcedir/bind.sysconfig \
    %_sourcedir/bind.service \
    %_sourcedir/bind.tmpfiles.conf \
    %_sourcedir/rndc.conf \
    %_sourcedir/rndc.key \
    addon/

find -type f -print0 |
	xargs -r0 grep -lZ '@[A-Z_]\+@' -- |
	xargs -r0 sed -i \
'
s,@ROOT@,%_chrootdir,g;
s,@DISTRO_OPTIONS@,-u %named_user,g;
s,@RUN_DIR@,%run_dir,g;
s,@NAMED_USER@,%named_user,g;
s,@LOG_DIR@,%log_dir,g;
' --

%build
%if_with docs
# see HTMLTARGET in configure.ac and doc/arm/Makefile.in
export SPHINX_BUILD=/usr/bin/sphinx-build-3
%endif

# https://bugzilla.redhat.com/show_bug.cgi?id=2122841#c30
%add_optflags -DOPENSSL_API_COMPAT=10100

%autoreconf
%configure \
	--localstatedir=/var \
	--with-libidn2 \
	--enable-linux-caps \
	--enable-fixed-rrset \
	 %{subst_with openssl} \
%if_with libjemalloc
	 --with-jemalloc=yes \
%endif
%if_with libjson
	--with-json-c=yes \
%endif
	--disable-static \
	--includedir=%{_includedir}/bind9 \
	--with-gssapi=yes \
	--enable-doh \
	#

%make_build

%if_with docs
%make doc
%endif

%install
%makeinstall_std

# Install additional headers.
install -pm644 lib/isc/errno2result.h %buildroot%_includedir/bind9/isc/

# Install startup scripts.
install -pD -m755 addon/bind.init %buildroot%_initdir/bind

# Install systemd service
install -pD -m644 addon/bind.service %buildroot%_unitdir/bind.service
install -pD -m644 addon/bind.tmpfiles.conf %buildroot%_tmpfilesdir/bind.conf

# Install configurations files
install -pm640 addon/rndc.conf %buildroot%_sysconfdir/
install -pD -m644 addon/bind.sysconfig %buildroot%_sysconfdir/sysconfig/bind

mkdir -p %buildroot%run_dir
mkdir -p %buildroot%log_dir

# Create a chrooted environment...
mkdir -p %buildroot%_chrootdir/{dev,%_sysconfdir,var/run/named,var/log/named,session,zone/slave}
for n in named options rndc local rfc1912 rfc1918; do
	install -pm640 "addon/bind.$n.conf" \
		"%buildroot%_chrootdir%_sysconfdir/$n.conf"
done
for n in localhost localdomain 127.in-addr.arpa empty; do
	install -pm640 "addon/bind.$n" \
		"%buildroot%_chrootdir/zone/$n"
	sed -i s/YYYYMMDDNN/%{timestamp}00/ \
		"%buildroot%_chrootdir/zone/$n"
done

install -pm640 addon/rndc.key bind.keys %buildroot%_chrootdir%_sysconfdir/
ln -snfr %buildroot%_sysconfdir/bind/{named.conf,bind.keys} \
	%buildroot%_sysconfdir/

# Create symlinks for unchrooted bind.
ln -snf . %buildroot%_chrootdir%_sysconfdir/bind
ln -snf ../zone %buildroot%_chrootdir%_sysconfdir/zone
ln -snfr %buildroot%_chrootdir%_sysconfdir %buildroot%_sysconfdir/bind

# Make use of syslogd-1.4.1-alt11 /etc/syslog.d/ feature.
/usr/bin/mksock %buildroot%_chrootdir/dev/log
mkdir %buildroot%_sysconfdir/syslog.d
ln -s %_chrootdir/dev/log %buildroot%_sysconfdir/syslog.d/bind
#... end of the chroot configuration.

# ALT docs
mkdir -p %buildroot%docdir
cp -a README.md %SOURCE3 %SOURCE4 %buildroot%docdir/

%if_with docs
mkdir -p %buildroot%docdir/arm
cp -a doc/arm/_build/html %buildroot%docdir/arm/
%endif

# alternative path for plugins
mkdir -p %buildroot%_libdir/named

# clean up la files
rm %buildroot%_libdir/bind/*.la

# filetrigger: delayed restart of named if named or its plugins were
# installed/upgraded
mkdir -p %buildroot%_rpmlibdir
cat > %buildroot%_rpmlibdir/%name-restart.filetrigger <<'EOF'
#!/bin/sh -u
# delayed restart of named if its plugins were installed/upgraded

grep -qsE -- '^%_libdir/(named|bind)/' && [ -f '%restart_flag' ] || exit 0
rm -f '%restart_flag'

service bind start
exit 0
EOF
chmod 0755 %buildroot%_rpmlibdir/%name-restart.filetrigger

%check
%if_with system_tests
# setup and teardown require root
perl bin/tests/system/testsock.pl || sudo sh -x bin/tests/system/ifconfig.sh up

%if_with enginepkcs11
# setup softhsm
# taken from https://gitlab.isc.org/isc-projects/images/-/blob/main/docker/bind9/debian-template/prep-softhsm-openssl-engine.sh.in
export OPENSSL_CONF="/tmp/openssl.cnf"
export SOFTHSM2_WORKDIR="/tmp/softhsm2"
export SOFTHSM2_CONF="$SOFTHSM2_WORKDIR/softhsm2.conf"
export SOFTHSM2_MODULE="%_libdir/softhsm/libsofthsm2.so"

rm -rf "$SOFTHSM2_WORKDIR"
mkdir -p "$SOFTHSM2_WORKDIR/tokens"
cat <<EOF > "$SOFTHSM2_CONF"
directories.tokendir = $SOFTHSM2_WORKDIR/tokens
objectstore.backend = file
log.level = DEBUG
EOF

cat > "$OPENSSL_CONF"<<EOF
openssl_conf = openssl_init

[openssl_init]
engines = engine_section

[engine_section]
pkcs11 = pkcs11_section

[pkcs11_section]
engine_id = pkcs11
dynamic_path = $(pkg-config libcrypto --variable=enginesdir)/pkcs11.so
MODULE_PATH = %_libdir/softhsm/libsofthsm2.so
init=0
EOF
%endif

# tests are run as current user
# see .gitlab-ci.yml
pushd bin/tests/system
# named must be unchrooted for upstream tests
export ALT_NAMED_OPTIONS=' -t / '
SYSTEMTEST_NO_CLEAN=1 %make_build -k test V=1

# teardown
popd
sudo sh bin/tests/system/ifconfig.sh down

%else
# today's (2021) vm-run (underlying KVM) is relatively slow.
# The complete tests suite takes ~1h on x86_64 and results are not stable atm.
# I tried to filter out some expected heavy tests by roughly the number of
# named instances they use (<=2). The expected acceptable tests time is ~10min
# on x86_64.

cat > run_smoke.sh <<'_EOF'
# setup
set -x
ulimit -n $(ulimit -Hn)
runas="$1"
perl bin/tests/system/testsock.pl || sh -x bin/tests/system/ifconfig.sh up
ip a

# tests
# named must be unchrooted for upstream tests
export ALT_NAMED_OPTIONS=' -t / '

pushd bin/tests/system
testdirs=
for testdir in */; do
    subns=$(find "$testdir" -maxdepth 1 -type d -name "ns[0-9]" | wc -l)
    if [ $subns -lt 2 ] && [ $subns -gt 0 ] ; then
        testdirs="$testdirs ${testdir%%*/}"
    fi
done

if [ -z "$testdirs" ] ; then
    echo 'Tests using ns==1 not found'
    exit 1
fi
setpriv --reuid "$runas" -- python3 -m pytest $testdirs

# teardown
popd
sh bin/tests/system/ifconfig.sh down
_EOF
time vm-run --kvm=cond --sbin -- /bin/bash --norc --noprofile -eu run_smoke.sh "$(id -un)"
%endif

%pre
/usr/sbin/groupadd -r -f %named_group
/usr/sbin/useradd -r -g %named_group -d %_chrootdir -s /dev/null -n \
    -c "Domain Name Server" %named_user >/dev/null 2>&1 ||:
[ -f %_initdir/named -a ! -L %_initdir/named ] && /sbin/chkconfig --del named ||:

# save running status and use it in post-transaction
rm -f '%restart_flag'

if [ "$1" -gt 1 ]; then
    SYSTEMCTL=systemctl
    if sd_booted && "$SYSTEMCTL" --version >/dev/null 2>&1; then
        "$SYSTEMCTL" is-active bind.service >/dev/null 2>&1 &&
        "$SYSTEMCTL" stop bind.service 2>/dev/null &&
        mkdir -p "$(dirname '%restart_flag')" &&
        touch '%restart_flag' 2>/dev/null ||:
    else
        %_initdir/bind status >/dev/null 2>&1 &&
        %_initdir/bind stop 2>/dev/null &&
        mkdir -p "$(dirname '%restart_flag')" &&
        touch '%restart_flag' 2>/dev/null ||:
    fi
fi

%pre_control bind-chroot bind-debug bind-slave bind-caps

%preun
%preun_service bind

%post
SYSLOGD_SCRIPT=/etc/init.d/syslogd
SYSLOGD_CONFIG=/etc/sysconfig/syslogd
if grep -qs '^SYSLOGD_OPTIONS=.*-a %_chrootdir/dev/log' "$SYSLOGD_CONFIG"; then
	# Remove artefacts of pre-syslog.d epoch.
	sed -i 's|^\(SYSLOGD_OPTIONS=.*\) \?-a %_chrootdir/dev/log|\1|' "$SYSLOGD_CONFIG"
	if [ -x "$SYSLOGD_SCRIPT" ]; then
		"$SYSLOGD_SCRIPT" condreload ||:
	fi
fi

%post_control -s enabled bind-chroot
%post_control -s disabled bind-debug bind-slave bind-caps

# next section is the copy of post_service, but
# it doesn't restart named since this is responsibility of filetrigger
SYSTEMCTL=systemctl
if sd_booted && "$SYSTEMCTL" --version >/dev/null 2>&1; then
    "$SYSTEMCTL" daemon-reload
    if [ "$1" -eq 1 ]; then
        "$SYSTEMCTL" -q preset bind
    fi
else
    if [ "$1" -eq 1 ]; then
        chkconfig --add bind
    else
        chkconfig bind resetpriorities
    fi
fi

%triggerun -- bind < 9.11.19-alt3
F=/etc/sysconfig/bind
if [ $2 -gt 0 -a -f $F ]; then
	grep -q '^#\?CHROOT=' $F || echo '#CHROOT="-t /"' >> $F
	grep -q '^#\?RETAIN_CAPS=' $F || echo '#RETAIN_CAPS="-r"' >> $F
fi

%files -n libbind
%_libdir/libbind9-%version.so
%_libdir/libdns-%version.so
%_libdir/libirs-%version.so
%_libdir/libisc-%version.so
%_libdir/libisccc-%version.so
%_libdir/libisccfg-%version.so
%_libdir/libns-%version.so

%files devel
%dir %docdir
%docdir/README.bind-devel
%_libdir/libbind9.so
%_libdir/libdns.so
%_libdir/libirs.so
%_libdir/libisc.so
%_libdir/libisccc.so
%_libdir/libisccfg.so
%_libdir/libns.so
%_includedir/bind9

%files
%dir %docdir
%docdir/README.md
%docdir/README.ALT
# plugins
%dir %_libdir/named
%dir %_libdir/bind
%_libdir/bind/filter-aaaa.so
%_libdir/bind/filter-a.so

%_bindir/arpaname
%_bindir/named-*
%_bindir/nsec3hash
%_bindir/dnssec-*
%_sbindir/ddns-confgen
%_sbindir/named
%_sbindir/rndc
%_sbindir/rndc-confgen
%_sbindir/tsig-keygen
%_sysconfdir/bind
%_sysconfdir/bind.keys
%_sysconfdir/named.conf
%config %_initdir/bind
%config(noreplace) %_sysconfdir/sysconfig/bind
%config(noreplace) %attr(640,root,%named_group) %_sysconfdir/rndc.conf
%dir %attr(770,root,%named_group) %run_dir
%dir %attr(770,root,%named_group) %log_dir
%_unitdir/bind.service
%_tmpfilesdir/bind.conf

%_rpmlibdir/%name-restart.filetrigger

%_man1dir/arpaname.1.*
%_man1dir/dnssec-*.*
%_man1dir/named-*.1.*
%_man1dir/nsec3hash.1.*
%_man5dir/*
%_man8dir/*

#chroot
%_sysconfdir/syslog.d/*
%defattr(640,root,%named_group,710)
%dir %_chrootdir
%dir %_chrootdir/dev
%dir %_chrootdir%_sysconfdir
%dir %attr(1770,root,%named_group) %_chrootdir/zone
%dir %attr(700,root,%named_group) %verify(not mode) %_chrootdir/zone/slave
%dir %attr(700,root,%named_group) %verify(not mode) %_chrootdir/var
%dir %attr(710,root,%named_group) %_chrootdir%_runtimedir
%dir %attr(1770,root,%named_group) %_chrootdir%_var%run_dir
%dir %attr(710,root,%named_group) %_chrootdir%_logdir
%dir %attr(1770,root,%named_group) %_chrootdir%log_dir
%dir %attr(700,root,%named_group) %_chrootdir/session
%config(noreplace) %_chrootdir%_sysconfdir/*.conf
%config(noreplace) %verify(not md5 mtime size) %_chrootdir%_sysconfdir/rndc.key
%_chrootdir%_sysconfdir/bind.keys
%attr(-,root,root) %_chrootdir%_sysconfdir/bind
%attr(-,root,root) %_chrootdir%_sysconfdir/zone
%config %_chrootdir/zone/localhost
%config %_chrootdir/zone/localdomain
%config %_chrootdir/zone/127.in-addr.arpa
%config %_chrootdir/zone/empty

%ghost %attr(666,root,root) %_chrootdir/dev/*

%files utils
%_bindir/delv
%_bindir/dig
%_bindir/mdig
%_bindir/host
%_bindir/nslookup
%_bindir/nsupdate
%_man1dir/delv.*
%_man1dir/dig.*
%_man1dir/mdig.*
%_man1dir/host.*
%_man1dir/nslookup.*
%_man1dir/nsupdate.*

%if_with docs
%files doc
%dir %docdir
%docdir/arm
%endif

%changelog
