Name: binwalk
Version: 2.3.4
Release: alt1

Summary: Firmware Analysis Tool

License: MIT License
Group: File tools
Url: https://github.com/ReFirmLabs/binwalk

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/ReFirmLabs/binwalk/archive/v%version.tar.gz
Source: %name-%version.tar

# TODO:
%add_python3_req_skip lzma
%add_python3_req_skip capstone

BuildRequires(pre): rpm-build-python3
BuildRequires: libdb4-devel python3-module-cmd2 python3-module-setuptools

# TODO (see https://bugzilla.altlinux.org/show_bug.cgi?id=19293):
#BuildPreReq: python3-module-magic > 5.0.0

#Requires: python3-module-matplotlib python3-module-numpy

%description
Binwalk is a firmware analysis tool designed to assist in the analysis,
extraction, and reverse engineering of firmware images and other binary blobs.
It is simple to use, fully scriptable,
and can be easily extended via custom signatures, extraction rules, and plugin modules.

Binwalk supports various types of analysis useful
for inspecting and reverse engineering firmware, including:

* Embedded file identification and extraction
* Executable code identification
* Type casting
* Entropy analysis and graphing
* Heuristic data analysis
* "Smart" strings analysis 

Binwalk's file signatures are (mostly) compatible with the magic signatures
used by the Unix file utility, and include customized/improved signatures
for files that are commonly found in firmware images such as compressed/archived files,
firmware headers, kernels, bootloaders, filesystems, etc. 

%prep
%setup

%build
%python3_build

%install
%python3_install
[ "%_libdir" = "/usr/lib" ] || mv %buildroot/usr/lib %buildroot%_libdir

%files
%_bindir/*
%python3_sitelibdir/%name/
%python3_sitelibdir/*.egg-info

%changelog
