Name: blobwars
Version: 2.00
Release: alt2

Summary: Mission and Objective based 2D Platform Game
License: %gpl2plus
Group: Games/Arcade

Url: http://www.parallelrealities.co.uk/blobWars.php
Source: %name-%version.tar
Patch1: blobwars-2.00-alt-fix-build.patch
Patch2: %name-2.00-alt-fixes.patch
#found in suse
Patch4: blobwars-icons_blobwars.desktop.patch
# SuSE PATCH-FIX-UPSTREAM https://sourceforge.net/p/blobwars/patches/8/
Patch5: reproducible.patch
Source1: %{name}.appdata.xml


BuildRequires: rpm-build-licenses

BuildRequires: gcc-c++ libSDL2-devel libSDL2_image-devel libSDL2_mixer-devel libSDL2_ttf-devel libSDL2_net-devel zlib-devel

# TODO: The package should depend on fonts-ttf-dejavu in runtime and take
# the font from there. rpm-build-fonts contains %_ttffontsdir macro.
BuildRequires: rpm-build-fonts fonts-ttf-dejavu

%description
Blob Wars : Metal Blob Solid. This is Episode I of the Blob Wars Saga.
You must undertake the role of fearless Blob solider, Bob, as he infiltrates
various enemy installations and hideouts in an attempt to rescue as many
MIAs as possible.

%prep
%setup -q
%patch1
%patch2
%patch4
%patch5 -p1

# from SuSE
# Correct Permissions
chmod 0644 Makefile*

# SED-FIX-OPENSUSE -- Fix paths and libraries
sed -i -e 's|USEPAK ?= 0|USEPAK ?= 1|;
           s|$(PREFIX)/games|$(PREFIX)/bin|;
           s|$(PREFIX)/share/games|$(PREFIX)/share|;
           s| -Werror||;
           s|$(CXX) $(LIBS) $(GAMEOBJS) -o $(PROG)|$(CXX) $(GAMEOBJS) $(LIBS) -o $(PROG)|;
           s|$(CXX) $(LIBS) $(PAKOBJS) -o pak|$(CXX) $(PAKOBJS) $(LIBS) -o pak|;
           s|$(CXX) $(LIBS) $(MAPOBJS) -o mapeditor|$(CXX) $(MAPOBJS) $(LIBS) -o mapeditor|' Makefile

# SED-FIX-OPENSUSE -- Fix pak
sed -i -e 's|gzclose(pak)|gzclose((gzFile)pak)|;
           s|gzclose(fp)|gzclose((gzFile)fp)|' src/pak.cpp


%build
%make_build VERSION=%version RELEASE=1

%install
%makeinstall DESTDIR=%buildroot

# icons
mkdir -p %buildroot%_liconsdir
install -m 644 icons/blobwars48x48.png %buildroot%_liconsdir/blobwars.png

%if_without pack
# fonts
pushd %buildroot%_datadir/%name
rm data/vera.ttf
# not Vera.ttf form fonts-ttf-vera, but DejaVuSans (fc-query data/vera.ttf for yourselves)
ln -s %_ttffontsdir/dejavu/DejaVuSans.ttf data/vera.ttf
popd
%endif

# Install appdata
mkdir -p %{buildroot}%{_datadir}/appdata
install -Dm 0644 %{S:1} %{buildroot}%{_datadir}/appdata

%find_lang %name

%files -f %name.lang
%_bindir/%name
%_datadir/%name
%_desktopdir/%name.desktop
%{_datadir}/appdata/*
%_iconsdir/hicolor/*/apps/%name.png
%doc doc/*

%changelog
