%def_enable selinux
# "setuid" or "none"
%define priv_mode none
%if %priv_mode == "setuid"
%def_disable userns
%endif

Name: bubblewrap
Version: 0.11.0
Release: alt1

Summary: Unprivileged sandboxing tool
License: LGPL-2.0-or-later
Group: System/Base
Url: https://github.com/projectatomic/bubblewrap

# Source-url: https://github.com/projectatomic/bubblewrap/releases/download/v%version/bubblewrap-%version.tar.xz
Vcs: https://github.com/projectatomic/bubblewrap.git
Source: %name-%version.tar
#Source: https://github.com/projectatomic/%name/releases/download/v%version/%name-%version.tar.xz

%if %priv_mode == "none"
Requires(pre): sysctl-conf-userns
%endif

%define meson_ver 0.49

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson >= %meson_ver gcc-c++ binutils-devel libelf-devel
BuildRequires: db2latex-xsl docbook-style-xsl libcap-devel xsltproc
BuildRequires: python3 bash-completion >= 2.10
%{?_enable_selinux:BuildRequires: libselinux-devel}

%description
Many container runtime tools like systemd-nspawn, docker, etc. focus on providing
infrastructure for system administrators and orchestration tools (e.g. Kubernetes) to run containers.

These tools are not suitable to give to unprivileged users,
because it is trivial to turn such access into to a fully privileged root shell on the host.

%prep
%setup

%build
%meson \
    %{subst_enable_meson_feature selinux selinux} \
    %{subst_enable_meson_bool userns require_userns}
%nil
%meson_build

%install
%meson_install

%files
%if %priv_mode == "setuid"
%attr(4511,root,root) %_bindir/bwrap
%else
%_bindir/bwrap
%endif
%_man1dir/bwrap*
%_datadir/bash-completion/completions/bwrap
%_datadir/zsh/site-functions/_bwrap

%changelog
