Name: buildbot
Version: 4.3.0
Release: alt1
Summary: Python-based continuous integration testing framework

Group: Development/Python
License: GPLv2+
Url: https://buildbot.net

# https://github.com/buildbot/buildbot
Source: %name-%version.tar


###############################################################################
# Wheel sources
###############################################################################
Source1: buildbot_www-%version-py3-none-any.whl
Source2: buildbot_console_view-%version-py3-none-any.whl
Source3: buildbot_grid_view-%version-py3-none-any.whl
Source4: buildbot_waterfall_view-%version-py3-none-any.whl
Source5: buildbot_badges-%version-py3-none-any.whl
Source6: buildbot_wsgi_dashboards-%version-py3-none-any.whl


###############################################################################
# Completion sources
###############################################################################
Source21: _buildbot
Source22: _buildbot-worker


###############################################################################
# Systemd sources
###############################################################################
Source31: buildbot@.service
Source32: buildbot-worker@.service

Patch1: alt-disable-sending-usage-by-default.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3

Requires: python3-module-service-identity buildbot-www python3(msgpack)
# Version requires due to move location of modules in buildbot-sqlalchemy
Requires: buildbot-sqlalchemy >= 1.4.44


###############################################################################
# Skip win requires
###############################################################################

%filter_from_requires /python3(pywintypes)/d
%filter_from_requires /python3(win32api)/d
%filter_from_requires /python3(win32con)/d
%filter_from_requires /python3(win32event)/d
%filter_from_requires /python3(win32file)/d
%filter_from_requires /python3(win32pipe)/d
%filter_from_requires /python3(win32process)/d
%filter_from_requires /python3(win32security)/d
%filter_from_requires /python3(win32service)/d
%filter_from_requires /python3(win32serviceutil)/d
%filter_from_requires /python3(winerror)/d


###############################################################################
# Change sqlalchemy requires
###############################################################################
%filter_from_requires s/python3(sqlalchemy.*).*/buildbot-sqlalchemy/


###############################################################################
# Main Package
###############################################################################

%description
The BuildBot is a system to automate the compile/test cycle required by
most software projects to validate code changes. By automatically
rebuilding and testing the tree each time something has changed, build
problems are pinpointed quickly, before other developers are
inconvenienced by the failure.


###############################################################################
# Package buildbot-worker
###############################################################################

%package worker
Group: Development/Python
Summary: Buildbot worker implementation
Requires: git-core python3(service_identity) python3(msgpack)

%description worker
%summary.


###############################################################################
# Package python3-module-buildbot-www
###############################################################################

%package -n python3-module-buildbot-www
Group: Development/Python
Summary: Buildboot web UI as python3 module

%description -n python3-module-buildbot-www
%summary.


###############################################################################
# Package buildbot-www
###############################################################################

# Need to create dummy package due to sisyphus_check limitations
%package www
Group: Development/Python
Summary: Buildbot web UI
Requires: python3-module-buildbot-www = %EVR

%description www
%summary.


###############################################################################
# Package python3-module-buildbot-www-extra-plugins
###############################################################################

%package -n python3-module-buildbot-www-extra-plugins
Group: Development/Python
Summary: Extra www plugins for buildboot as python3 module

%description -n python3-module-buildbot-www-extra-plugins
%summary.


###############################################################################
# Package buildbot-www-extra-plugins
###############################################################################

# Need to create dummy package due to sisyphus_check limitations
%package www-extra-plugins
Group: Development/Python
Summary: Extra www plugins for buildboot
Requires: python3-module-buildbot-www-extra-plugins = %EVR

%description www-extra-plugins
%summary.


###############################################################################
# Package buildbot-checkinstall
###############################################################################

%package checkinstall
Summary: Chekinstall for %name
Group: Other
BuildArch: noarch
Requires(pre): buildbot = %EVR buildbot-worker = %EVR buildbot-www = %EVR
Requires: /dev/pts python3-module-pbr python3-module-treq

%description checkinstall
%summary.


###############################################################################
# Build and Install
###############################################################################

%prep
%setup
%patch1 -p1
sed -i '/buildbot_windows_service/d' master/setup.py
rm -v master/buildbot/scripts/windows_service.py
sed -i '/buildbot_worker_windows_service/d' worker/setup.py
rm -v worker/buildbot_worker/scripts/windows_service.py
rm -v master/docs/manual/mydashboard.html

%build
for name in master worker; do
    pushd "$name"
    %python3_build_debug
    popd
done

%install
pushd master
%python3_install
install -Dm 0644 docs/buildbot.1 %buildroot/%_man1dir/buildbot.1
popd

pushd worker
%python3_install
install -Dm 0644 docs/buildbot-worker.1 %buildroot/%_man1dir/buildbot-worker.1
popd

bbmodulesdir=%_libexecdir/buildbot/modules
sys_path="\\    sys.path.insert(0, '$bbmodulesdir')"
python_path="    import os; os.environ['PYTHONPATH'] = '$bbmodulesdir'"
for b in %buildroot%_bindir/buildbot %buildroot%_bindir/buildbot-worker; do
    sed -i "/if __name__ == '__main__':/a$sys_path\n$python_path" "$b"
done

python3 -mzipfile -e %SOURCE1 %buildroot/%python3_sitelibdir
python3 -mzipfile -e %SOURCE2 %buildroot/%python3_sitelibdir
python3 -mzipfile -e %SOURCE3 %buildroot/%python3_sitelibdir
python3 -mzipfile -e %SOURCE4 %buildroot/%python3_sitelibdir
python3 -mzipfile -e %SOURCE5 %buildroot/%python3_sitelibdir
python3 -mzipfile -e %SOURCE6 %buildroot/%python3_sitelibdir

install -Dm 0644 %SOURCE21 %buildroot/%_datadir/zsh/site-functions/_buildbot
install -Dm 0644 %SOURCE22 \
    %buildroot/%_datadir/zsh/site-functions/_buildbot-worker

mkdir -p %buildroot%_localstatedir/%{name}-worker
mkdir -p %buildroot%_localstatedir/%name

mkdir -p %buildroot%_unitdir
install -m 0644 %SOURCE31 %buildroot%_unitdir/
install -m 0644 %SOURCE32 %buildroot%_unitdir/

rm %buildroot%python3_sitelibdir/buildbot-*.egg-info/requires.txt


###############################################################################
# Pre
###############################################################################
%pre
groupadd -r -f _%name 2>/dev/null ||:
useradd -r -g _%name -c 'Buildbot master' \
        -d %_localstatedir/%name _%name 2>/dev/null ||:

%pre worker
groupadd -r -f _%{name}-worker 2>/dev/null ||:
useradd -r -g _%{name}-worker -c 'Buildbot worker' \
        -d %_localstatedir/%{name}-worker  _%{name}-worker 2>/dev/null ||:


###############################################################################
# Chekinstall
###############################################################################
%post checkinstall
# create and start master
buildbot create-master master
mv master/master.cfg.sample master/master.cfg
buildbot start master

# create and start worker
buildbot-worker create-worker worker localhost example-worker pass
buildbot-worker start worker


###############################################################################
# Files
###############################################################################

%files -n python3-module-buildbot-www
%python3_sitelibdir/buildbot_www
%python3_sitelibdir/buildbot_www-*.dist-info
%python3_sitelibdir/buildbot_console_view
%python3_sitelibdir/buildbot_console_view-*.dist-info
%python3_sitelibdir/buildbot_grid_view
%python3_sitelibdir/buildbot_grid_view-*.dist-info
%python3_sitelibdir/buildbot_waterfall_view
%python3_sitelibdir/buildbot_waterfall_view-*.dist-info

%files www

%files -n python3-module-buildbot-www-extra-plugins
%python3_sitelibdir/buildbot_badges
%python3_sitelibdir/buildbot_badges-*.dist-info
%python3_sitelibdir/buildbot_wsgi_dashboards
%python3_sitelibdir/buildbot_wsgi_dashboards-*.dist-info

%files www-extra-plugins

%files worker
%doc worker/docs
%_man1dir/buildbot-worker.1.*
%_bindir/buildbot-worker
%python3_sitelibdir/buildbot_worker
%python3_sitelibdir/buildbot_worker-*.egg-info
%dir %attr(0750,_%{name}-worker,_%{name}-worker) %_localstatedir/%{name}-worker
%_unitdir/%{name}-worker*
%_datadir/zsh/site-functions/_%{name}-worker

%files
%doc README.rst master/docs
%_man1dir/buildbot.1.*
%_bindir/buildbot
%python3_sitelibdir/buildbot
%python3_sitelibdir/buildbot-*.egg-info
%dir %attr(0750,_%name,_%name) %_localstatedir/%name
%_unitdir/%{name}*
%exclude %_unitdir/%{name}-worker*
%_datadir/zsh/site-functions/_%name

%files checkinstall

%changelog
