%define oname caffeine
Name: %oname-ng
Version: 4.2.0
Release: alt1
Summary: Prevent screensaving and powersaving
Group: Graphical desktop/Other
License: GPLv3 and LGPLv3
Url: https://codeberg.org/WhyNotHugo/caffeine-ng

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildArch: noarch

BuildRequires(pre): rpm-macros-python3 rpm-build-gir
BuildRequires: rpm-build-python3
BuildRequires: meson
BuildRequires: python3-devel
BuildRequires: scdoc
BuildRequires: git-core

Obsoletes: %oname =< %EVR
Provides: %oname

%add_python3_req_skip gi.repository.Notify

%description
Caffeine is a little daemon that sits in you systray, and prevents the
screensaver from showing up, or the systems from going to sleep. It does so when
an application is fullscreened (eg: youtube), or when you click on the systray
icon (which you can do, when, eg: reading).

This is a fork of Caffeine 2.4, since later versions dropped support for the
systray icon in favour of only automatic detection of fullscreen apps only,
which resulted rather controversial.

The intention of this fork is to also evolve on its own, not only fixing issues,
but also implemented missing features, when relevant.

%description -l ru_RU.UTF-8
Caffeine - маленькая служба, которая блокирует активацию скринсейвера и переход
компьютера в ждущий режим, когда активное окно находится в полноэкранном режиме
(например: просматриваете YouTube), или при нажатии на значок в системном лотке.

Это форк Caffeine 2.4, так как в более поздних версиях прекращена поддержка
значка в системном лотке в пользу только автоматического обнаружения
полноэкранных приложений.

Цель этого форка самостоятельное развитие, а не только устранение проблем,
реализация недостающих функций, когда это уместно.

%prep
%setup
%autopatch -p1

%build
git config --global user.email "user at altlinux.org"
git config --global user.name "user"
git init-db
git add . -A
git commit -a -m "%version"
git tag -m "%version" %version

%meson
%meson_build

%install
%meson_install

#mv %buildroot%python3_sitelibdir%prefix/* %buildroot%prefix/
#mv %buildroot%python3_sitelibdir%_sysconfdir %buildroot/

%find_lang %name

# remove unused icons
rm -r %buildroot%_iconsdir/ubuntu-mono-dark

%files -f %name.lang
%doc *.rst
%_sysconfdir/xdg/autostart/%oname.desktop
%_bindir/*
%_man1dir/*.1.*
%_desktopdir/*.desktop
%_datadir/%oname
%_iconsdir/hicolor/*/*/*
%_pixmapsdir/*
%python3_sitelibdir/*
#_datadir/%oname
%_datadir/glib-2.0/schemas/*

%changelog
