%define _unpackaged_files_terminate_build 1
%define _libexecdir /usr/libexec
%define _localstatedir /var

%def_with check

Name: certmonger
Version: 0.79.20
Release: alt2
Summary: Certificate status monitor and PKI enrollment client
License: GPL-3.0-or-later
Group: System/Base
Url: https://pagure.io/certmonger
VCS: https://pagure.io/certmonger
Source0: %name-%version.tar
Patch: %name-%version-alt.patch
Requires: dbus

BuildRequires: libcurl-devel
BuildRequires: libdbus-devel
BuildRequires: libidn2-devel
BuildRequires: libkrb5-devel
BuildRequires: libldap-devel
BuildRequires: libnss-devel >= 3.69.0-alt1
BuildRequires: libpopt-devel
BuildRequires: libssl-devel
BuildRequires: libtalloc-devel
BuildRequires: libtevent-devel
BuildRequires: libxml2-devel
BuildRequires: libjansson-devel >= 2.12
BuildRequires: libsystemd-devel

%if_with check
BuildRequires: /proc
BuildRequires: dbus-tools-gui
BuildRequires: dos2unix
BuildRequires: nss-utils
BuildRequires: openssl
BuildRequires: python3(dbus)
%endif

%description
Certmonger is a service which is primarily concerned with getting your
system enrolled with a certificate authority (CA) and keeping it enrolled.

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
        --disable-rpath \
        --disable-dsa \
	--enable-systemd \
	--enable-tmpfiles \
	--with-homedir=/run/certmonger \
	--with-tmpdir=/run/certmonger \
        --enable-pie \
        --enable-now

%make_build

%install
%makeinstall_std

mkdir -p %buildroot%_sharedstatedir/%name/{cas,requests}
%find_lang %name

%check
%make check

%post
%post_service %name

# certmaster is no longer supported
if [ "$1" -ge 2 ]; then
    %_bindir/getcert remove-ca -c certmaster 2>&1 ||:
fi

%preun
%preun_service %name

%triggerpostun -- certmonger <= 0.79.7-alt1
# update certmonger helper paths for existing installations
# /usr/lib/certmonger/ => /usr/libexec/certmonger/
set -o errexit
set -o nounset
set -o pipefail

export LC_ALL=C

help () {
    printf -- 'Please, check and update certmonger CAs helpers manually\n' >&2
    exit 0
}

getcert refresh-ca -a >/dev/null 2>&1 || help
cas_list="$(getcert list-cas | grep -o "^CA '.*':" | cut -d\' -f2 | \
              tr '\n' ' ')" || \
         help

old_path=" /usr/lib/certmonger/"
new_path=" /usr/libexec/certmonger/"
helper=
modified_helper=
for ca in $cas_list; do
    # helper could be empty
    helper="$(getcert list-cas -c "$ca" | grep 'helper-location:' | \
                cut -d':' -f2)" || \
           continue
    if [ -z "$helper" -o -n "${helper##*$old_path*}" ]; then
        continue
    fi
    modified_helper="${helper//$old_path/$new_path}"
    # remove leading whitespace
    modified_helper="$(sed 's/^[[:space:]]*//' <<<"$modified_helper")"
    getcert modify-ca -c "$ca" -e "$modified_helper" || help
done
getcert refresh-ca -a >/dev/null 2>&1 || help

%files -f %name.lang
%doc README.md STATUS doc/*.txt
%config(noreplace) %_sysconfdir/dbus-1/system.d/org.fedorahosted.certmonger.conf
%config(noreplace) %_sysconfdir/certmonger/certmonger.conf
%attr(0644,root,root) %config(noreplace) %_tmpfilesdir/certmonger.conf
%_datadir/dbus-1/services/org.fedorahosted.certmonger.service
%_datadir/dbus-1/system-services/org.fedorahosted.certmonger.service
%_unitdir/certmonger.service
%dir %_sysconfdir/certmonger
%_bindir/getcert
%_bindir/ipa-getcert
%_bindir/local-getcert
%_bindir/selfsign-getcert
%_sbindir/certmonger
%dir %_libexecdir/certmonger
%_libexecdir/certmonger/certmonger-session
%_libexecdir/certmonger/dogtag-ipa-renew-agent-submit
%_libexecdir/certmonger/dogtag-submit
%_libexecdir/certmonger/ipa-submit
%_libexecdir/certmonger/local-submit
%_libexecdir/certmonger/scep-submit
%dir %_sharedstatedir/certmonger
%_sharedstatedir/certmonger/cas/
%_sharedstatedir/certmonger/local/
%_sharedstatedir/certmonger/requests/
%_man1dir/getcert-*.1.*
%_man1dir/getcert.1.*
%_man1dir/ipa-getcert.1.*
%_man1dir/local-getcert.1.*
%_man1dir/selfsign-getcert.1.*
%_man5dir/certmonger.conf.5.*
%_man8dir/certmonger-*.8.*
%_man8dir/certmonger.8.*

%changelog
