%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict
%define soname 4.5

%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}

%define longdesc The CFD General Notation System (CGNS) provides a general, portable, and \
extensible standard for the storage and retrieval of computational fluid \
dynamics (CFD) analysis data. It consists of a collection of \
conventions, and free and open software implementing those conventions. \
It is self-descriptive, machine-independent, well-documented, and \
administered by an international steering committee. It is also an \
American Institute of Aeronautics and Astronautics (AIAA) Recommended \
Practice.

Name: cgns
Version: 4.5.0
Release: alt1
Summary: CFD General Notation System
Group: Sciences/Mathematics
License: Zlib
URL: https://github.com/CGNS/CGNS
VCS: https://github.com/CGNS/CGNS.git
Source: %name-%version.tar

Patch1: cgns-4.5.0-alt-install.patch
Patch2: cgns-4.5.0-alt-fix-build-tkint.patch

BuildRequires: cmake gcc-c++ gcc-fortran zlib-devel libGL-devel tk-devel
BuildRequires: libGLU-devel xorg-xproto-devel libXmu-devel libXtst-devel
BuildRequires: libXcomposite-devel libXcursor-devel libXdamage-devel
BuildRequires: libXdmcp-devel libXfixes-devel libXft-devel libXi-devel
BuildRequires: libXpm-devel libXrandr-devel libXrender-devel libXv-devel
BuildRequires: libXxf86misc-devel libXinerama-devel libXxf86vm-devel
BuildRequires: libhdf5-devel

Requires: lib%name%soname = %EVR
Obsoletes: %name-seq < %EVR

%description
%longdesc

The system consists of two parts: (1) a standard format for recording
the data, and (2) software that reads, writes, and modifies data in that
format. The format is a conceptual entity established by the
documentation; the software is a physical product supplied to enable
developers to access and produce data recorded in that format.

%package -n lib%name%soname
Summary: Shared libraries of CFD General Notation System
Group: System/Libraries

%description -n lib%name%soname
%longdesc

This package contains shared libraries of CGNS.

%package -n lib%name-devel
Summary: Development files of CFD General Notation System
Group: Development/C++
Requires: lib%name%soname = %EVR
Obsoletes: lib%name-seq-devel < %EVR

%description -n lib%name-devel
%longdesc

This package contains development files of CGNS.

%package -n lib%name-devel-static
Summary: Development files of CFD General Notation System
Group: Development/C++
Requires: lib%name-devel = %EVR

%description -n lib%name-devel-static
%longdesc

This package contains development files of CGNS.

%prep
%setup
%patch1 -p1
%patch2 -p1

%build
%add_optflags -D_FILE_OFFSET_BITS=64

%cmake \
	-DCGNS_ENABLE_TESTS=ON \
	-DCGNS_ENABLE_FORTRAN=ON \
	-DCGNS_BUILD_CGNSTOOLS=ON \
	-DCGNS_ENABLE_HDF5=ON \
	%nil

%cmake_build

%install
%cmakeinstall_std

%files
%_bindir/*
%_datadir/cgnstools
%_desktopdir/*.desktop

%files -n lib%name%soname
%doc license.txt
%doc README.md
%_libdir/*.so.%soname

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_libdir/cmake/cgns

%files -n lib%name-devel-static
%_libdir/*.a

%changelog
