%define git_date 20240303
%define git_commit 0ff3440

Name: citra
Version: 2104
Release: alt1

Summary: Nintendo 3DS emulator
License: GPLv2
Group: Emulators

Url: https://%name-emu.org/
Packager: Nazarov Denis <nenderus@altlinux.org>

ExclusiveArch: x86_64 aarch64 %e2k

# Source-url: https://github.com/%name-emu/%name-nightly/releases/download/nightly-%version/%name-unified-source-%git_date-%git_commit.tar.xz
Source: %name-unified-source-%git_date-%git_commit.tar

BuildRequires: ctest
BuildRequires: doxygen
BuildRequires: git-core
BuildRequires: glslang
BuildRequires: graphviz
BuildRequires: libSDL2-devel
BuildRequires: libavfilter-devel
BuildRequires: libavformat-devel
BuildRequires: libbacktrace-devel
BuildRequires: libdbus-devel
BuildRequires: libportaudio2-devel
BuildRequires: libswresample-devel
BuildRequires: libusb-devel
BuildRequires: pipewire-jack-libs-devel
BuildRequires: python3-dev
BuildRequires: qt6-multimedia
BuildRequires: qt6-multimedia-devel
BuildRequires: qt6-tools-devel

%description
Citra is an open-source Nintendo 3DS emulator and debugger, written with portability in mind.

%prep
%setup -n %name-unified-source-%git_date-%git_commit

# Enforce package versioning in GUI
sed -i \
-e 's|@GIT_BRANCH@|HEAD|g' \
-e 's|@GIT_DESC@|%git_commit|g' \
-e 's|@BUILD_FULLNAME@|Nightly %version|g' \
src/common/scm_rev.cpp.in

%build
%add_optflags

%cmake \
	-DENABLE_QT_TRANSLATION:BOOL=ON \
	-DUSE_SYSTEM_SDL2:BOOL=ON \
	-DUSE_SYSTEM_OPENSSL:BOOL=ON \
	-DUSE_SYSTEM_LIBUSB:BOOL=ON \
	-DCITRA_WARNINGS_AS_ERRORS:BOOL=OFF \
	-Wno-dev

%cmake_build

%install
%cmakeinstall_std

%check
cd %_cmake__builddir
ctest

%files
%_bindir/%name
%_bindir/%name-qt
%_bindir/%name-room
%_desktopdir/%name-qt.desktop
%_datadir/mime/packages/%name.xml
%_iconsdir/hicolor/scalable/apps/%name.svg
%_man6dir/%name.6*
%_man6dir/%name-qt.6*

%changelog
