%def_disable snapshot
%define _name clutter-gtk
%define ver_major 1.8
%define api_ver 1.0
%def_enable introspection
%def_enable docs

Name: %{_name}3
Version: %ver_major.4
Release: alt1.1

Summary: Library integrating clutter with GTK+3
License: LGPL-2.1-or-later
Group: System/Libraries
Url: https://wiki.gnome.org/Projects/Clutter

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif
BuildRequires(pre): rpm-macros-meson
BuildRequires: meson libgtk+3-devel >= 3.21.0 libclutter-devel >= 1.24
%{?_enable_docs:BuildRequires: gtk-doc}
%{?_enable_introspection:BuildRequires(pre): rpm-build-gir
BuildRequires: libjson-glib-gir-devel libcogl-gir-devel libclutter-gir-devel libgtk+3-gir-devel}

%description
Library integrating clutter with GTK+

%package -n lib%name
Summary: Library integrating clutter with GTK+
Group: System/Libraries

%description -n lib%name
Library integrating clutter with GTK+

%package -n lib%name-devel
Summary: Header files for clutter-gtk library
Group: Development/Other
Requires: lib%name = %version-%release

%description -n lib%name-devel
Header files for clutter-gtk library

%package -n lib%name-devel-doc
Summary: Documentation for clutter-gtk library
Group: Development/Other
BuildArch: noarch
Conflicts: lib%name-devel < %version

%description -n lib%name-devel-doc
Development documentation files for clutter-gtk library

%package -n lib%name-gir
Summary: GObject introspection data for the clutter-gtk library
Group: System/Libraries
Requires: lib%name = %version-%release
Requires: gir-repository libclutter-gir

%description -n lib%name-gir
GObject introspection data for the clutter-gtk library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the clutter-gtk library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release
Requires: gir-repository-devel libclutter-gir-devel

%description -n lib%name-gir-devel
GObject introspection devel data for the clutter-gtk library

%prep
%setup -n %_name-%version
touch AUTHORS

%build
%meson \
    %{?_enable_docs:-Denable_docs=true}
%nil
%meson_build

%install
%meson_install

%find_lang cluttergtk-%api_ver

%files -n lib%name -f cluttergtk-%api_ver.lang
%doc AUTHORS NEWS
%_libdir/lib%_name-*.so.*

%files -n lib%name-devel
%_includedir/%_name-*
%_libdir/lib%_name-*.so
%_pkgconfigdir/*.pc

%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/*.typelib

%files -n lib%name-gir-devel
%_girdir/*.gir
%endif

%changelog
