%define _unpackaged_files_terminate_build 1

%define libname lib%name
%define sover 1

Name: cpr
Version: 1.11.1
Release: alt1

Summary: C++ Requests: Curl for People, a spiritual port of Python Requests
License: MIT
Group: System/Libraries
Url: https://docs.libcpr.org
VCS: https://github.com/libcpr/cpr

# Source-url: https://github.com/%libname/%name/archive/refs/tags/%version.tar.gz
Source: %name-%version.tar
Patch1: alt-build-only-shared-lib.patch

BuildRequires: gcc-c++
BuildRequires: cmake
BuildRequires: pkgconfig(libcurl)
BuildRequires: pkgconfig(libssl)

%description
C++ Requests is a simple wrapper around libcurl inspired by the
excellent Python Requests project.

Despite its name, libcurl's easy interface is anything but, and making
mistakes, misusing it is a common source of error and frustration.
Using the more expressive language facilities of C++17 (or C++11 in
case you use cpr < 1.10.0), this library captures the essence of making
network calls into a few concise idioms.

%package -n %libname%sover
Summary: %summary
Group: System/Libraries

%description -n %libname%sover
C++ Requests is a simple wrapper around libcurl inspired by the
excellent Python Requests project.

Despite its name, libcurl's easy interface is anything but, and making
mistakes, misusing it is a common source of error and frustration.
Using the more expressive language facilities of C++17 (or C++11 in
case you use cpr < 1.10.0), this library captures the essence of making
network calls into a few concise idioms.

%package -n %libname-devel
Summary: Development files for the %name
Group: Development/C++
Requires: %libname%sover = %EVR

%description -n %libname-devel
The package contains libraries and header files for developing
applications that use %name.

%prep
%setup
%patch1 -p1

%build
%cmake \
    -DCPR_USE_SYSTEM_CURL=ON
%cmake_build

%install
%cmake_install

%files -n %libname%sover
%doc README.md LICENSE
%_libdir/%libname.so.%{sover}*

%files -n %libname-devel
%_includedir/%name/*
%_libdir/%libname.so
%_libdir/cmake/%name/*.cmake

%changelog
