%def_with check
Summary: CUDF (Common Upgradeability Description Format) tools and libraries
Name: cudf
Version: 0.10
Release: alt2
VCS: https://gitlab.com/irill/cudf.git
Source: %name-%version.tar
Url: https://www.mancoosi.org/cudf/
License: LGPLv3
Group: Development/ML
BuildRequires: ocaml dune ocaml-extlib-devel perl-podlators ocaml-ocamlbuild libncurses-devel glib2-devel
%if_with check
BuildRequires: ocaml-ounit-devel
%endif

%description
CUDF (for Common Upgradeability Description Format) is a format for describing
upgrade scenarios in package-based Free and Open Source Software distribution.

libCUDF is a library to manipulate so called CUDF documents. A CUDF document
describe an upgrade problem, as faced by package managers in popular
package-based GNU/Linux distributions.

%package tools
Summary: CUDF (Common Upgradeability Description Format) command-line tools
Group: System/Configuration/Packaging

%description tools
CUDF (for Common Upgradeability Description Format) is a format for describing
upgrade scenarios in package-based Free and Open Source Software distribution.

libCUDF is a library to manipulate so called CUDF documents. A CUDF document
describe an upgrade problem, as faced by package managers in popular
package-based GNU/Linux distributions.

This package contains command line tools to manipulate CUDF and related
documents. In particular it contains cudf-check, which enables checking of
document properties such as installation consistency and matching of problems
with their solutions.

%package -n ocaml-%name-devel
Summary: CUDF (Common Upgradeability Description Format) OCaml development stuff
Group: Development/ML

%description -n ocaml-%name-devel
CUDF (for Common Upgradeability Description Format) is a format for describing
upgrade scenarios in package-based Free and Open Source Software distribution.

libCUDF is a library to manipulate so called CUDF documents. A CUDF document
describe an upgrade problem, as faced by package managers in popular
package-based GNU/Linux distributions.

This package contains the development stuff needed to use libCUDF in your OCaml
programs.

%prep
%setup

%build
%dune_build -p cudf

%install
%dune_install

%check
%dune_check --release

%files tools
%_bindir/cudf-check
%_bindir/cudf-parse-822

%files -n ocaml-%name-devel
%_libdir/ocaml/cudf

%changelog
