%define _unpackaged_files_terminate_build 1
%define goipath github.com/linuxdeepin/dde-api
%define forgeurl https://github.com/linuxdeepin/dde-api

# Run tests in check section
# disable for bootstrapping
%def_without check

Name: deepin-api
Version: 6.0.12
Release: alt1

Summary: Golang bingding for dde-daemon

License: GPL-3.0+
Group: Graphical desktop/Other
Url: https://github.com/linuxdeepin/dde-api

Source: %url/archive/%version/dde-api-%version.tar.gz
Patch: %name-%version-%release.patch

#Requires: deepin-desktop-base rfkill
#Requires(pre): shadow-utils dbus-tools

BuildRequires(pre): rpm-build-golang rpm-build-python3
BuildRequires: /proc
BuildRequires: libalsa-devel libcairo-devel libgio-devel libgtk+3-devel libgdk-pixbuf-devel libgudev-devel libcanberra-devel libpulseaudio-devel librsvg-devel libpoppler-glib-devel libpolkitqt5-qt5-devel libsystemd-devel libXfixes-devel libXcursor-devel libX11-devel libXi-devel deepin-gettext-tools libgdk-pixbuf-xlib-devel

%description
%summary.

%package -n golang-%name-devel
Summary: %summary
Group: Graphical desktop/Other
AutoReq: no
# BuildArch: noarch

%description -n golang-%name-devel
%summary.

This package contains library source intended for
building other packages which use import path with
%goipath prefix.

%prep
%setup -n dde-api-%version
%patch -p1

%build
export GOPATH="$(pwd)/vendor"
export GOFLAGS="-mod=vendor"
export GO111MODULE=off

%make

%install
export GOPATH="%go_path"

%makeinstall_std SYSTEMD_SERVICE_DIR="%_unitdir" -i

# HOME directory for user deepin-sound-player
mkdir -p %buildroot%_sharedstatedir/deepin-sound-player/.cache/dconf/
touch %buildroot%_sharedstatedir/deepin-sound-player/.cache/dconf/user
install -Dm644 archlinux/deepin-api.sysusers %buildroot%_sysusersdir/deepin-api.conf

%files
%doc README.md LICENSE
%_bindir/*
%dir %_libexecdir/deepin-api/
%_libexecdir/deepin-api/*
%_iconsdir/hicolor/??x??/actions/*
%_iconsdir/hicolor/???x???/actions/*
%_iconsdir/hicolor/scalable/actions/*
%_datadir/dbus-1/*
%_datadir/polkit-1/*
%_unitdir/*.service
%_sharedstatedir/polkit-1/*
%dir %_datadir/dde-api/
%dir %_datadir/dde-api/data/
%_datadir/dde-api/data/*
%_sysusersdir/deepin-api.conf
%dir %_sharedstatedir/deepin-sound-player/
%dir %_sharedstatedir/deepin-sound-player/.cache/
%dir %_sharedstatedir/deepin-sound-player/.cache/dconf/
%_sharedstatedir/deepin-sound-player/.cache/dconf/user

%files -n golang-%name-devel
%go_path/src/%goipath

%changelog
