%def_without clang

%define repo dde-application-manager
%define _libexecdir %_prefix/libexec

Name: deepin-application-manager
Version: 1.2.14
Release: alt1

Summary: App manager for Deepin

License: LGPL-3.0-or-later
Group: Graphical desktop/Other
Url: https://github.com/linuxdeepin/dde-application-manager

Source: %url/archive/%version/%repo-%version.tar.gz
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-ninja
BuildRequires: cmake libgtest-devel libsystemd-devel python3-module-setuptools dqt6-base-devel dtk6-common-devel libdtk6core-devel
%if_with clang
BuildRequires: clang-devel
%else
BuildRequires: gcc-c++
%endif

%description
%summary.

%prep
%setup -n %repo-%version
%patch -p1

%build
%if_with clang
export CC="clang"
export CXX="clang++"
export AR="llvm-ar"
export NM="llvm-nm"
export READELF="llvm-readelf"
%endif
export CMAKE_PREFIX_PATH=%_dqt6_libdir/cmake:$CMAKE_PREFIX_PATH
export PATH=%_dqt6_bindir:$PATH
%cmake \
  -GNinja \
  -DCMAKE_BUILD_TYPE=RelWithDebInfo \
  -DCMAKE_INSTALL_SYSCONFDIR=%_sysconfdir \
  -DCMAKE_SKIP_INSTALL_RPATH:BOOL=OFF \
  -DCMAKE_INSTALL_RPATH=%_dqt6_libdir \
#
cmake --build "%_cmake__builddir" -j%__nprocs

%install
%cmake_install

# don't use dpkg
rm -rf %buildroot%_sysconfdir/dpkg/dpkg.cfg.d/am-update-hook

%files
%_bindir/%repo
%_bindir/dde-am
%_bindir/app-identifier
%dir %_libexecdir/deepin/
%dir %_libexecdir/deepin/application-manager/
%_libexecdir/deepin/application-manager/app-launch-helper
%_libexecdir/deepin/application-manager/app-update-notifier
%_libexecdir/deepin/application-manager/dockEnv.sh
%_libexecdir/deepin/application-manager/debFix.sh
%_unitdir/org.desktopspec.ApplicationUpdateNotifier1.service
%_userunitdir/org.desktopspec.ApplicationManager1.service
%dir %_userunitdir/dde-session-initialized.target.wants/
%_userunitdir/dde-session-initialized.target.wants/org.desktopspec.ApplicationManager1.service
%dir %_userunitdir/app-DDE-.service.d/
%_userunitdir/app-DDE-.service.d/override.conf
%_datadir/dbus-1/system-services/org.desktopspec.ApplicationUpdateNotifier1.service
%_datadir/dbus-1/system.d/org.desktopspec.ApplicationUpdateNotifier1.conf
%_datadir/dbus-1/services/org.desktopspec.ApplicationManager1.service
%dir %_datadir/%repo/
%_datadir/%repo/org.desktopspec.*.xml
%dir %_datadir/deepin/
%dir %_datadir/deepin/%repo/
%dir %_datadir/deepin/%repo/hooks.d/
%_datadir/deepin/%repo/hooks.d/1-dockEnv.json
%_datadir/deepin/%repo/hooks.d/2-debFix.json
%dir %_datadir/dsg/
%dir %_datadir/dsg/configs/
%dir %_datadir/dsg/configs/%repo/
%_datadir/dsg/configs/%repo/com.deepin*.json
%dir %_datadir/dsg/configs/org.deepin.dde.application-manager/
%_datadir/dsg/configs/org.deepin.dde.application-manager/org.deepin.dde.am.json

%changelog
