%define repo deepin-manual

%ifarch %not_qt5_qtwebengine_arches
%def_disable qtwebengine
%else
%def_enable qtwebengine
%endif

Name: deepin-help
Version: 6.0.6.0.4.35f8
Release: alt1

Summary: Help files for DDE

License: GPL-3.0-or-later and CC0-1.0 and BSD-3-Clause
# LICENSES/: CC0-1.0 and CC-BY-4.0 and MIT and BSD-3-Clause and LGPL-3.0 and GPL-3.0
# tools/: CC0-1.0
# tests/: CC0-1.0 and GPL-3.0-or-later
# src/: GPL-3.0+ and CC0-1.0 and BSD-3-Clause
# src/web*/*/qwebchannel.js: BSD-3-Clause or Qt.Commercial
Group: Graphical desktop/Other
Url: https://github.com/linuxdeepin/deepin-manual

Source: %url/archive/%version/%repo-%version.tar.gz
Patch: %name-%version-%release.patch

Provides: %repo = %EVR
Obsoletes: %repo < %EVR

Requires: %name-data

BuildRequires(pre): rpm-build-ninja
BuildRequires(pre): rpm-macros-qt5-webengine
BuildRequires: gcc-c++ cmake qt5-base-devel qt5-tools-devel qt5-webchannel-devel dtk5-widget-devel qt5-x11extras-devel libgmock-devel
%if_enabled qtwebengine
BuildRequires: qt5-webengine-devel
%endif

%description
%summary.

%package data
Summary: Data files for %name
Group: Graphical desktop/Other
Provides: %repo-data = %EVR
Obsoletes: %repo-data < %EVR

%description data
Data files for %name.

%prep
%setup -n %repo-%version
%patch -p1

%build
%if_enabled qtwebengine
export PATH=%_qt5_bindir:$PATH
%cmake \
    -GNinja \
    -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    -DAPP_VERSION=%version \
    -DVERSION=%version \
    -DLIB_INSTALL_DIR=%_libdir \
#
cmake --build "%_cmake__builddir" -j%__nprocs

%install
%cmake_install
%endif

%files
%if_enabled qtwebengine
%doc LICENSE README.md CHANGELOG.md
%_bindir/dman
%_bindir/dmanHelper
%_desktopdir/%repo.desktop
%_datadir/dbus-1/services/com.deepin.Manual.Open.service
%_datadir/dbus-1/services/com.deepin.Manual.Search.service
%_iconsdir/hicolor/scalable/apps/%repo.svg
%endif

%files data
%if_enabled qtwebengine
%_datadir/%repo/
%endif

%changelog
