%def_without clang

%define repo dmusic
%define dmusic_ver 1

Name: deepin-music
Version: 7.0.5
Release: alt2

Summary: Awesome music player with brilliant and tweakful UI Deepin-UI based

License: GPL-3.0+
Group: Sound
Url: https://github.com/linuxdeepin/deepin-music

Source: %url/archive/%version/%name-%version.tar.gz
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-ninja
# Automatically added by buildreq on Sat Oct 28 2023
# optimized out: cmake-modules gcc-c++ glibc-kernheaders-generic glibc-kernheaders-x86 libavcodec-devel libavutil-devel libdouble-conversion3 libdtkcore-devel libdtkgui-devel libglvnd-devel libgpg-error libgsettings-qt libicu-devel libmpris-qt5 libp11-kit libdqt5-core libdqt5-dbus libdqt5-gui libdqt5-multimedia libdqt5-network libdqt5-printsupport libdqt5-qml libdqt5-qmlmodels libdqt5-quick libdqt5-sql libdqt5-svg libdqt5-widgets libdqt5-x11extras libdqt5-xml libsasl2-3 libssl-devel libstartup-notification libstdc++-devel libudisks2-qt5 pkg-config python3 python3-base python3-dev python3-module-setuptools dqt5-base-devel dqt5-declarative-devel dqt5-tools sh5 zlib-devel
BuildRequires: cmake kf5-kcodecs-devel libSDL2-devel libavformat-devel libdtkdeclarative-devel libdtkwidget-devel libtag-devel libvlc-devel mpris-qt5-devel dqt5-multimedia-devel dqt5-svg-devel dqt5-tools-devel dqt5-declarative-devel udisks2-qt5-devel

%if_with clang
BuildRequires: clang-devel
BuildRequires: lld-devel
%else
BuildRequires: gcc-c++
%endif

Requires: vlc-mini ffmpeg dtkdeclarative

%description
%summary.

%package -n lib%repo%dmusic_ver
Summary: %repo library for %name
Group: System/Libraries
Provides: lib%name = %version
Obsoletes: lib%name < %version

%description -n lib%repo%dmusic_ver
The package provides %repo library for %name.

%package -n lib%repo-devel
Summary: Static libraries for %name
Group: Development/C++
Provides: %name-devel = %version
Obsoletes: %name-devel < %version

%description -n lib%repo-devel
The package provides development files for %repo library.

%prep
%setup
%patch -p1

%build
%if_with clang
%define optflags_lto -flto=thin
export CC=clang
export CXX=clang++
export LDFLAGS="-fuse-ld=lld $LDFLAGS"
%else
%define optflags_lto %nil
%endif
export CMAKE_PREFIX_PATH=%_dqt5_libdir/cmake:$CMAKE_PREFIX_PATH
export PKG_CONFIG_PATH=%_dqt5_libdir/pkgconfig:$PKG_CONFIG_PATH
export PATH=%_dqt5_bindir:$PATH
%cmake \
    -GNinja \
    -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    -DCMAKE_INSTALL_LIBDIR=%_libdir \
    -DLIB_INSTALL_DIR=%_libdir \
    -DCMAKE_SKIP_INSTALL_RPATH:BOOL=no \
    -DCMAKE_INSTALL_RPATH=%_dqt5_libdir \
    -DVERSION=%version
cmake --build %_cmake__builddir -j%__nprocs

%install
%cmake_install
%find_lang --with-qt %name

%files -f %name.lang
%doc CHANGELOG.md LICENSE README.md
%_bindir/%name
# package translations outside %%find_lang
%dir %_datadir/%name/
%dir %_datadir/%name/translations/
%_datadir/%name/translations/deepin-music_ky@Arab.qm
# ---
%_desktopdir/%name.desktop
%_iconsdir/hicolor/scalable/apps/%name.svg
%dir %_datadir/dsg/
%dir %_datadir/dsg/configs/
%dir %_datadir/dsg/configs/deepin-music/
%_datadir/dsg/configs/deepin-music/org.deepin.music.json
%dir %_datadir/deepin-manual/
%dir %_datadir/deepin-manual/manual-assets/
%dir %_datadir/deepin-manual/manual-assets/application/
%dir %_datadir/deepin-manual/manual-assets/application/%name/
%_datadir/deepin-manual/manual-assets/application/%name/music/

%files -n lib%repo%dmusic_ver
%_libdir/lib%repo.so.%{dmusic_ver}*

%files -n lib%repo-devel
%_libdir/lib%repo.so

%changelog
