%def_without clang
# Not actual CMakeLists.txt
%def_without cmake

Name: deepin-screen-recorder
Version: 6.0.5
Release: alt1

Summary: Default screen recorder application for Deepin

License: GPL-3.0-or-later
# 3rdparty/googletest: BSD-3-Clause and Apache-2.0
Group: Video
Url: https://github.com/linuxdeepin/deepin-screen-recorder

Source: %url/archive/%version/%name-%version.tar.gz
Patch: %name-%version-%release.patch
Patch1: deepin-screen-recorder-6.0.5-alt-rename-os-version.patch
Patch2: deepin-screen-recorder-6.0.5-alt-fix-GNUInstallDirs.patch
Patch3: deepin-screen-recorder-6.0.5-alt-fix-opencv4.patch

Provides: %name-data = %version
Obsoletes: %name-data < %version

BuildRequires(pre): rpm-macros-dqt5
# Automatically added by buildreq on Fri Dec 15 2023
# optimized out: gcc-c++ glib2-devel glibc-kernheaders-generic glibc-kernheaders-x86 gstreamer1.0-devel libX11-devel libXcursor-devel libXext-devel libXfixes-devel libXi-devel libXtst-devel libavcodec-devel libavformat-devel libavutil-devel libdouble-conversion3 libdtkcore-devel libdtkgui-devel libglvnd-devel libgpg-error libgsettings-qt libgst-plugins1.0 libp11-kit libdqt5-concurrent libdqt5-core libdqt5-dbus libdqt5-gui libdqt5-multimedia libdqt5-network libdqt5-printsupport libdqt5-svg libdqt5-widgets libdqt5-x11extras libdqt5-xml libsasl2-3 libstartup-notification libstdc++-devel libswscale-devel libudev-devel libxcb-devel pkg-config python3 python3-base python3-dev python3-module-setuptools dqt5-base-devel dqt5-declarative-devel dqt5-tools sh5 tbb-devel xorg-proto-devel
BuildRequires: deepin-dock-devel deepin-qt-dbus-factory-devel dwayland-devel gst-plugins1.0-devel kf5-kconfig-devel kf5-ki18n-devel kf5-kwayland-devel kf5-kwindowsystem-devel libdtkwidget-devel libffmpegthumbnailer-devel libimagevisualresult-devel libopencv-devel libportaudio2-devel libswresample-devel libusb-devel libv4l-devel libxcbutil-devel dqt5-multimedia-devel dqt5-svg-devel dqt5-tools-devel dqt5-x11extras-devel

# /etc/uos-version detection
BuildRequires: deepin-desktop-base

%if_with clang
BuildRequires: clang-devel lld-devel
%else
BuildRequires: gcc-c++
%endif

%if_with cmake
BuildRequires: cmake rpm-build-ninja
%endif

%description
%summary.

%prep
%setup -n %name-%version
%autopatch -p1

%build
export PATH=%_dqt5_bindir:$PATH
export PKG_CONFIG_PATH=%_dqt5_libdir/pkgconfig:$PKG_CONFIG_PATH
%if_enabled clang
%define optflags_lto -flto=thin
%endif
%if_enabled cmake
    %if_enabled clang
    export CC=clang
    export CXX=clang++
    export LDFLAGS="-fuse-ld=lld $LDFLAGS"
    %endif
    export CMAKE_PREFIX_PATH=%_dqt5_libdir/cmake:$CMAKE_PREFIX_PATH
%cmake \
    -GNinja \
    -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    -DCMAKE_SKIP_INSTALL_RPATH:BOOL=OFF \
    -DCMAKE_INSTALL_RPATH=%_dqt5_libdir 
    -DVERSION=%version \
    -DLIB_INSTALL_DIR=%_libdir \
    -DDEFINES+="VERSION=%version" \
    %nil
cmake --build "%_cmake__builddir" -j%__nprocs
%else
%qmake_dqt5 \
    CONFIG+=nostrip \
    VERSION=%version \
    APP_VERSION=%version \
    LIB_INSTALL_DIR=%_libdir \
    LIB_DESTINATION=%_lib \
    QMAKE_RPATHDIR=%_dqt5_libdir \
    %if_enabled clang
        QMAKE_STRIP= -spec linux-clang \
    %endif
    %nil
%make_build
%endif

%install
%if_enabled cmake
    %cmake_install
%else
    %makeinstall INSTALL_ROOT=%buildroot
%endif
%find_lang %name

%files -f %name.lang
%doc LICENSE README.md CHANGELOG.md
%_bindir/%name
%_bindir/deepin-pin-screenshots
%_desktopdir/%name.desktop
%_datadir/%name/
%dir %_libdir/dde-dock/
%dir %_libdir/dde-dock/plugins/
%_libdir/dde-dock/plugins/libdeepin-screen-recorder-plugin.so
%_libdir/dde-dock/plugins/libshot-start-plugin.so
%_iconsdir/hicolor/scalable/apps/%name.svg
%_iconsdir/hicolor/scalable/apps/deepin-screenshot.svg
%_datadir/dbus-1/services/com.deepin.ScreenRecorder.service
%_datadir/dbus-1/services/com.deepin.Screenshot.service
%_datadir/dbus-1/services/com.deepin.PinScreenShots.service
%_datadir/glib-2.0/schemas/com.deepin.dde.dock.module.shot-start-plugin.gschema.xml
%dir %_datadir/deepin-manual/
%dir %_datadir/deepin-manual/manual-assets/
%dir %_datadir/deepin-manual/manual-assets/application/
%dir %_datadir/deepin-manual/manual-assets/application/%name/
%_datadir/deepin-manual/manual-assets/application/%name/screen-capture/

%changelog
