%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%global optflags_lto %optflags_lto -ffat-lto-objects

%define realname DevIL

Name: devil
Version: 1.7.8
Release: alt5
Summary: Cross-platform image loading and manipulation toolkit
Group: System/Libraries
License: LGPLv2+
Url: http://openil.sourceforge.net

Source: %name-%version.tar

Patch0: devil-1.7.8-alt-png_set_expand_gray.patch
Patch1: devil-1.7.8-deb-CVE-2009-3994.patch
Patch2: devil-deb-FTBFS-il.h.patch
Patch3: devil-1.7.8-fedora-jasper2.patch
Patch4: devil-1.7.8-alt-fix-missing-include.patch

BuildRequires: gcc-c++ libSDL-devel liballegro-devel libjpeg-devel
BuildRequires: liblcms-devel libmng-devel libpng-devel libtiff-devel zlib-devel
BuildRequires: libGL-devel libGLU-devel libGLUT-devel libX11-devel
BuildRequires: openexr-devel libjasper-devel libICE-devel libXext-devel
BuildRequires: libXrender-devel libSM-devel libXmu-devel libXi-devel

%description
Developer's Image Library (DevIL) is a programmer's library to develop
applications with very powerful image loading capabilities, yet is easy
for a developer to learn and use. Ultimate control of images is left
to the developer, so unnecessary conversions, etc. are not performed.
DevIL utilizes a simple, yet powerful, syntax.
DevIL can load, save, convert, manipulate, filter and display a wide
variety of image formats.

%package -n lib%name
Summary: Cross-platform image loading and manipulation toolkit.
Group: System/Libraries

%description -n lib%name
Developer's Image Library (DevIL) is a programmer's library to develop
applications with very powerful image loading capabilities, yet is easy
for a developer to learn and use. Ultimate control of images is left
to the developer, so unnecessary conversions, etc. are not performed.
DevIL utilizes a simple, yet powerful, syntax.
DevIL can load, save, convert, manipulate, filter and display a wide
variety of image formats.

%package -n lib%name-devel
Summary: DevIL development files.
Group: Development/C++
Requires: lib%name = %EVR

%description -n lib%name-devel
Developer's Image Library (DevIL) is a programmer's library to develop
applications with very powerful image loading capabilities, yet is easy
for a developer to learn and use. This package contains development files.

%package -n lib%name-devel-static
Summary: DevIL development static files.
Group: Development/C++
Requires: lib%name-devel = %EVR

%description -n lib%name-devel-static
DevIL development static files.

%package -n lib%name-doc
Summary: DevIL documentation
Group: Development/Documentation

%description -n lib%name-doc
Developer's Image Library (DevIL) is a programmer's library to develop
applications with very powerful image loading capabilities, yet is easy
for a developer to learn and use. This package contains documentation

%prep
%setup

%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

%build
%add_optflags -D_FILE_OFFSET_BITS=64

%configure \
	--disable-win32 \
	--disable-directx \
	--with-pic \
        --enable-ILU \
        --enable-ILUT
sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
%make_build

%install
%makeinstall devildir=%buildroot%_datadir/%name
rm -rf %buildroot%_infodir/*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/IL
%_pkgconfigdir/*
%_bindir/*

%files -n lib%name-devel-static
%_libdir/*.a

%files -n lib%name-doc
%doc README Libraries.txt TODO CREDITS AUTHORS

%changelog
