Name: devscripts
Version: 2.22.2
Release: alt2.qa1
Source: %{name}_%version.tar.xz
Source1: devscripts-po4a.conf
Patch: devscripts-uscan-no_ssl_namecheck.patch
License: GPLv2
Group: Development/Other
Url: http://packages.debian.org/devscripts
Summary: Scripts to make the life of a Debian Package maintainer easier

# Automatically added by buildreq on Mon Jun 20 2022
# optimized out: glibc-kernheaders-generic glibc-kernheaders-x86 libgpg-error perl perl-Dpkg perl-Encode perl-Encode-Locale perl-File-Which perl-HTTP-Date perl-HTTP-Message perl-Locale-gettext perl-Pod-Escapes perl-Pod-Parser perl-Pod-Simple perl-Pod-Usage perl-Tie-RefHash perl-Time-Piece perl-Try-Tiny perl-URI perl-parent perl-podlators pkg-config python3 python3-base python3-dev sh4 xml-common xz
BuildRequires: docbook5-style-xsl dpkg help2man perl-File-HomeDir perl-JSON-PP perl-Pod-Checker perl-String-ShellQuote perl-autodie perl-libwww po4a python3-module-setuptools xsltproc

BuildRequires: perl-DB_File perl-HTTP-Tiny perl-File-DesktopEntry perl-Git-Wrapper perl-List-Compare perl-Moo perl-IPC-Run perl-TimeDate perl-GitLab-API-v4 perl-File-DirList perl-File-Touch perl(JSON.pm)

%description
Devscripts provides several scripts which may be of use to Debian
developers.  The following gives a summary of the available scripts --
please read the manpages for full details about the use of these
scripts.  They are contributed by multiple developers; for details of
the authors, please see the code or manpages.

Also, many of these scripts have dependencies on other packages, but
rather than burden the package with a large number of dependencies,
most of which will not be needed by most people, the individual
dependencies are listed as "Recommends" in the control file.  This
ensures that the packages will be installed by default but allows
users to remove them if desired.  The dependencies and recommendations
are listed in square brackets in the description below, as well as in
the Description field in the control file.

%package -n python3-module-%name
Group: Development/Other
Summary: Python3 bingings for %name
Buildarch: noarch
%description -n python3-module-%name
Python3 bingings for %name, %summary

%package -n checkbashisms

Summary: Check shell scripts for common bash-specific contructs
Group: Development/Other
BuildArch: noarch

%description -n checkbashisms
checkbashisms checks whether a /bin/sh script contains any common
bash-specific contructs.
It is the part of the Debian devscripts package.

%prep
%setup
%patch -p0
sed -i 's/^[.]TQ/.TP/' scripts/diff2patches.1
grep -rl /usr/share/sgml/docbook/stylesheet/xsl/nwalsh/manpages/docbook.xsl . |
	while read N; do
		sed -i 's@/usr/share/sgml/docbook/stylesheet/xsl/nwalsh/manpages/docbook.xsl@/usr/share/sgml/docbook/xsl-ns-stylesheets/manpages/docbook.xsl@g' "$N"
	done
sed -i 's/ --install-layout=deb//' scripts/Makefile

%build
%make COMPL_DIR=%_datadir/bash-completion/completions

%install
mkdir -p %buildroot/%_bindir \
	%buildroot/%prefix/lib/devscripts \
	%buildroot/%_datadir/devscripts \
	%buildroot/%_man1dir \
	%buildroot/%_man5dir \
	%buildroot/%perl_vendorlib \
	%buildroot/%_datadir/bash-completion/completions

%makeinstall DESTDIR=%buildroot  COMPL_DIR=%_datadir/bash-completion/completions

install */*.1 %buildroot/%_man1dir/
install */*.5 %buildroot/%_man5dir/
install -D cowpoke.conf %buildroot%_sysconfdir/cowpoke.conf

# XXX
cp -r lib/Devscripts %buildroot/%perl_vendorlib/
touch %buildroot%_sysconfdir/cvsdeb.conf

# Fix dmd conflict
mv %buildroot/%_man1dir/dget.1 %buildroot/%_man1dir/dget-debian.1
mv %buildroot/%_bindir/dget %buildroot/%_bindir/dget-debian

%files
%doc README*
%exclude %_defaultdocdir/%name
%_bindir/*
%_mandir/man*/*
%prefix/lib/devscripts
%_datadir/devscripts
%_datadir/bash-completion/completions/*
%perl_vendorlib/Devscripts
%config %_sysconfdir/[^b]*
%exclude %_bindir/checkbashisms
%exclude %_man1dir/checkbashisms.1*
%exclude %_datadir/bash-completion/completions/checkbashisms
%exclude %_datadir/bash-completion/completions/bts

%files -n checkbashisms
%_bindir/checkbashisms
%_man1dir/checkbashisms.1*
%_datadir/bash-completion/completions/checkbashisms

%add_python3_req_skip apt debian debian.changelog
%files -n python3-module-%name
%python3_sitelibdir_noarch/*

%changelog
