# -*- mode: rpm-spec; mode: folding -*-
# vim: set ft=spec:
# vim600: set fdm=marker:

%define patchlevel %nil
%define patchlevel -P1

%define _unpackaged_files_terminate_build 1

Name: dhcp
Version: 4.4.3.P1
Release: alt2
Epoch: 1

Summary: Dynamic Host Configuration Protocol (DHCP) distribution
License: MPL-2.0
Group: System/Servers
Url: https://www.isc.org/dhcp/

%define srcname dhcp-%version%{?patchlevel:%patchlevel}
Source0: dhcp-%version.tar
Source1: dhcp-dynamic-dns-examples.tar
Source2: dhcpd.conf.sample
Source3: update_dhcp.pl
Source4: dhcpd.init
Source5: dhcrelay.init
Source8: dhcpd.sysconfig
Source9: dhcrelay.sysconfig
Source10: dhcpd.chroot.all
Source11: dhcpd.chroot.conf
Source12: dhcpd.chroot.lib
Source14: dhclient-script.alt
Source15: dhclient-hooks.tar
Source16: dhclient.sysconfig
Source17: dhcpd6.init
Source18: dhcpd6.sysconfig
Source19: dhcpd6.chroot.all
Source20: dhcpd6.chroot.conf
Source21: dhcpd6.chroot.lib
Source22: dhcrelay6.init
Source23: dhcrelay6.sysconfig
Source24: dhcrelay6
Source25: dhcpd.service
Source26: dhcpd6.service
Source27: dhcrelay.service
Source28: dhcrelay6.service
Source29: dhcpd-chroot.control
Source30: dhcpd6-chroot.control

Patch0001: 0001-Apply-dhcp-3.0.5-alt-warnings.patch.patch
Patch0002: 0002-Apply-dhcp-3.0.3-alt-defaults.patch.patch
Patch0003: 0003-Apply-dhcp-3.0.3-alt-daemonize.patch.patch
Patch0004: 0004-Apply-dhcp-3.0.5-owl-alt-support-contact.patch.patch
Patch0005: 0005-Update-and-apply-dhcp-3.0.4-owl-bound.patch.patch
Patch0006: 0006-Apply-dhcp-3.0.3-rh-dhcpctl-man.patch.patch
Patch0007: 0007-Apply-dhcp-3.0.3-rh-assemble_udp_ip_header.patch.patch
Patch0008: 0008-Apply-dhcp-3.0.3-rh-failover-ports.patch.patch
Patch0009: 0009-Apply-manpage-correction-from-RH-184484.patch
Patch0010: 0010-Update-and-apply-dhcp-3.0.3-owl-alt-drop_priv.patch.patch
Patch0011: 0011-dhclient-Add-several-command-line-options-which-etcn.patch
Patch0012: 0012-dhclient-Check-if-dhclient-already-running.patch
Patch0013: 0013-dhclient-Request-more-options-by-default.patch
Patch0014: 0014-Prevent-file-descriptors-leak.patch
Patch0015: 0015-Drop-garbage-char.patch
Patch0016: 0016-Fix-segfault-in-case-of-NULL-timeout.patch
Patch0017: 0017-Ensure-64-bit-platforms-parse-lease-file-dates-times.patch
Patch0018: 0018-Support-Classless-Static-Route-Option-for-DHCPv4-RFC.patch
Patch0019: 0019-Don-t-send-log-messages-to-the-stderr-with-f-option.patch
Patch0020: 0020-Document-ALT-specific-in-the-dhclient-script-manpage.patch
Patch0021: 0021-Ignore-checksums-on-the-loopback-interface.patch
Patch0022: 0022-dhcpd-and-dhcrelay-Override-default-user-jail-dir-an.patch
Patch0023: 0023-examples-dhcpd-dhcpv6.conf-Drop-dhcpv6-lease-file-na.patch
Patch0024: 0024-fix-segfault-on-x86-64-on-8-network.patch
Patch0025: 0025-Apply-dhcp-4.3.5-bound.diff.patch
Patch0026: 0026-dhclient-Add-onetime-and-nounicast-options.patch
Patch0027: 0027-dhclient-rename-timeout-option-to-timeout.patch
Patch0028: 0028-Build-with-extern-bind-libraries.patch
Patch0029: 0029-explicitly-include-bind-headers-that-are-required.patch
Patch0030: 0030-Fix-possible-bufer-overflow.patch
Patch0031: 0031-Silence-format-truncation-warning.patch
Patch0032: 0032-Fix-printf-format.patch
Patch0033: 0033-Fix-linking.patch
Patch0034: 0034-Build-libdhcp-as-static-library.patch
Patch0035: 0035-dhclient-Fix-divide-by-zero-error.patch
Patch0036: 0036-dhclient-Don-t-hang-before-returning.patch
Patch0037: 0037-dhcrelay-fix-relaying-of-return-packets.patch
Patch0038: 0038-dhcpctl.3-avoid-undefined-manpage-macro.patch
Patch0039: 0039-fix-spelling-mistakes.patch

# due to copy_resolv_conf/copy_resolv_lib
BuildPreReq: chrooted >= 0.3

BuildPreReq: groff-base, libcap-devel

# Chrooted environments
%define ROOT %_localstatedir/%name

BuildRequires: libcap-devel
BuildRequires: libisc-export-dhcp-devel

%package common
Summary: Dynamic Host Configuration Protocol (DHCP) distribution
Group: System/Servers
BuildArch: noarch

%package client
Summary: The ISC DHCP client daemon
Group: System/Servers
Requires(pre): %name-common = %epoch:%version-%release
Requires: %name-libs = %epoch:%version-%release libshell
# NetworkManager can use dhclient
Provides: nm-dhcp-client

%package server
Summary: The ISC DHCP server daemon
Group: System/Servers
Requires(pre): %name-common = %epoch:%version-%release
Requires: %name-libs = %epoch:%version-%release
Requires: /var/empty
Provides: %name = %epoch:%version-%release
Obsoletes: dhcp, dhcpd

%package relay
Summary: The ISC DHCP relay daemon
Group: System/Servers
Requires(pre): %name-common = %epoch:%version-%release
Requires: %name-libs = %epoch:%version-%release
Requires: /var/empty

%package omshell
Summary: The ISC DHCP OMAPI command shell tool
Group: System/Servers
Requires(pre): %name-common = %epoch:%version-%release
Requires: %name-libs = %epoch:%version-%release

%package devel
Summary: Development headers and libraries for interfacing to the DHCP server
Group: Development/Other
Requires: dhcp-common = %epoch:%version-%release
Requires: %name-libs = %epoch:%version-%release

%package libs
Summary: Shared libraries used by ISC dhcp client and server
Group: System/Libraries

# {{{ descriptions
%description
The ISC Dynamic Host Configuration Protocol distribution provides a
freely redistributable reference implementation of all aspects of the
DHCP protocol.

%description common
The ISC Dynamic Host Configuration Protocol distribution provides a
freely redistributable reference implementation of all aspects of the
DHCP protocol.

This package contains files and directories common for the ISC DHCP
client, server and relay subpackages.

%description client
The Internet Software Consortium DHCP Client, dhclient, provides a
means for configuring one or more network interfaces using the Dynamic
Host Configuration Protocol, BOOTP protocol, or if these protocols
fail, by statically assigning an address.

%description server
The Internet Software Consortium DHCP Server, dhcpd, implements the
Dynamic Host Configuration Protocol (DHCP) and the Internet Bootstrap
Protocol (BOOTP).  DHCP allows hosts on a TCP/IP network to request
and be assigned IP addresses, and also to discover information about
the network to which they are attached.  BOOTP provides similar
functionality, with certain restrictions.

%description relay
The Internet Software Consortium DHCP Relay Agent, dhcrelay, provides a
means for relaying DHCP and BOOTP requests from a subnet to which no
DHCP server is directly connected to one or more DHCP servers on other
subnets.

You will have to define the environment variable SERVERS and optionally
OPTIONS in /etc/sysconfig/dhcrelay before starting the server.

%description omshell
The OMAPI Command Shell, omshell, provides an interactive way to connect
to, query, and possibly change, the ISC DHCP Server's state via OMAPI,
the Object Management API.  By using OMAPI and omshell, you do not have
to stop, make changes, and then restart the DHCP server, but can make
the changes while the server is running.  Omshell provides a way of
accessing OMAPI.

%description devel
DHCP devel contains header files and libraries for developing
with the Internet Software Consortium (ISC) dhcpctl API.

%description libs
This package contains shared libraries used by ISC dhcp client and
server

# }}}

%prep
%setup -a1 -a15
%patch0001 -p2
%patch0002 -p2
%patch0003 -p2
%patch0004 -p2
%patch0005 -p2
%patch0006 -p2
%patch0007 -p2
%patch0008 -p2
%patch0009 -p2
%patch0010 -p2
%patch0011 -p2
%patch0012 -p2
%patch0013 -p2
%patch0014 -p2
%patch0015 -p2
%patch0016 -p2
%patch0017 -p2
%patch0018 -p2
%patch0019 -p2
%patch0020 -p2
%patch0021 -p2
%patch0022 -p2
%patch0023 -p2
%patch0024 -p2
%patch0025 -p2
%patch0026 -p2
%patch0027 -p2
%patch0028 -p2
%patch0029 -p2
%patch0030 -p2
%patch0031 -p2
%patch0032 -p2
%patch0033 -p2
%patch0034 -p2
%patch0035 -p2
%patch0036 -p2
%patch0037 -p2
%patch0038 -p2
%patch0039 -p2

install -pm644 %_sourcedir/update_dhcp.pl .
find -type f -print0 |
	xargs -r0 grep -EZl '(/etc|ETCDIR)/(dhclient|dhcpd|dhcrelay)' -- |
	xargs -r0 sed -i 's,\(/etc\|ETCDIR\)/\(dhclient\|dhcpd\|dhcrelay\),\1/%name/\2,g' --
find client -type f -not -name Makefile\* -print0 |
	xargs -r0 grep -FZl DBDIR -- |
	xargs -r0 sed -i 's,DBDIR,%ROOT/dhclient/state,g' --
find server -type f -not -name Makefile\* -print0 |
	xargs -r0 grep -FZl DBDIR -- |
	xargs -r0 sed -i 's,DBDIR,%ROOT/dhcpd/state,g' --
find server -type f -not -name Makefile\* -print0 |
	xargs -r0 grep -FZl '%ROOT/dhcpd/state/dhcpd6' -- |
	xargs -r0 sed -i 's,%ROOT/dhcpd/state/dhcpd6,%ROOT/dhcpd6/state/dhcpd6,g' --

%build
%add_optflags -fpie -fno-strict-aliasing -Wno-unused -Wno-error=stringop-overflow -Dlint
%ifnarch %e2k
# lcc: omapi.c:854: -Werror=array-bounds
%add_optflags -Werror
%endif

cp configure.ac+lt configure.ac
%autoreconf
%configure \
	--with-libbind=%{_includedir}/bind9 \
	--with-libbind-libs=%{_libdir}
## ./configure --copts "%optflags"
%make_build DEBUG=
## CC=%__cc DEBUG=

# {{{ install

%install
rln()
{
	local target=$1 && shift
	local source=$1 && shift
	target=`relative "$target" "$source"`
	ln -snf "$target" "%buildroot$source"
}

mkdir -p %buildroot{%ROOT,/etc/{sysconfig,%name/dhclient.d}}
%makeinstall_std \
	INSTALL='install -pm644' \
	MANINSTALL='$(INSTALL)' \
	LIBDIR=%_libdir \
	INCDIR=%_includedir \
	ADMMANDIR=%_mandir/man8 \
	FFMANDIR=%_mandir/man5 \
	LIBMANDIR=%_mandir/man3 \
	USRMANDIR=%_mandir/man1 \
	#

# dhcpd
install -pD -m755 %SOURCE29 %buildroot%_controldir/dhcpd-chroot
install -pD -m755 %SOURCE30 %buildroot%_controldir/dhcpd6-chroot

install -pD -m600 %_sourcedir/dhcpd.conf.sample \
	%buildroot/etc/%name/dhcpd.conf.sample

install -pD -m600 doc/examples/dhcpd-dhcpv6.conf \
	%buildroot/etc/%name/dhcpd6.conf.sample

mv %buildroot/etc/*.example %buildroot/etc/%name/

for dhcpd in dhcpd dhcpd6; do
	install -pD -m755 %_sourcedir/$dhcpd.init \
		%buildroot%_initdir/$dhcpd
	install -pD -m644 %_sourcedir/$dhcpd.sysconfig \
		%buildroot/etc/sysconfig/$dhcpd
	install -pD -m644 %_sourcedir/$dhcpd.service \
		%buildroot/%systemd_unitdir/$dhcpd.service
	mkdir -p %buildroot%ROOT/$dhcpd/state
	touch %buildroot%ROOT/$dhcpd/state/$dhcpd.leases
	# Make use of syslogd-1.4.1-alt11 /etc/syslog.d/ feature.
	mkdir -p %buildroot%ROOT/$dhcpd/dev
	mksock %buildroot%ROOT/$dhcpd/dev/log
	mkdir -p %buildroot/etc/syslog.d
	ln -s %ROOT/$dhcpd/dev/log %buildroot/etc/syslog.d/$dhcpd
	# Resolver infrastructure
	for n in all conf lib; do
		install -pD -m750 "%_sourcedir/$dhcpd.chroot.$n" \
			"%buildroot/etc/chroot.d/$dhcpd.$n"
	done
	sed -i "s,%%ROOT,%ROOT/$dhcpd,g" "%buildroot/etc/chroot.d/$dhcpd."*
	mkdir -p %buildroot%ROOT/$dhcpd{/etc,/%_lib,/var/{nis,yp/binding}}
	touch %buildroot%ROOT/$dhcpd{/etc/{localtime,hosts,services,{host,nsswitch,resolv}.conf},/var/nis/NIS_COLD_START}
done

# Don't package static libraries.
# Remove them to avoid LTO check.
rm %buildroot%_libdir/lib*.a

# dhcrelay
install -pD -m750 %SOURCE24 %buildroot%_sbindir/dhcrelay6
for dhcrelay in dhcrelay dhcrelay6; do
	install -pD -m755 %_sourcedir/$dhcrelay.init \
		%buildroot%_initdir/$dhcrelay
	install -pD -m644 %_sourcedir/$dhcrelay.service \
		%buildroot/%systemd_unitdir/$dhcrelay.service
	install -pD -m644 %_sourcedir/$dhcrelay.sysconfig \
		%buildroot/etc/sysconfig/$dhcrelay
done

# dhclient
mkdir -p %buildroot/%_sysconfdir/sysconfig/
install -pD -m644 %_sourcedir/dhclient.sysconfig \
	%buildroot/%_sysconfdir/sysconfig/dhclient

install -pD -m755 %SOURCE14 %buildroot/sbin/dhclient-script
rln /sbin/dhclient-script /etc/%name/
rln %_sbindir/dhclient /sbin/dhclient

mkdir -p %buildroot%ROOT/dhclient/state
touch %buildroot%ROOT/dhclient/state/dhclient.leases
echo '# DHCP client config file' > %buildroot/etc/%name/dhclient.conf
chmod 644 %buildroot/etc/%name/dhclient.conf
mkdir -p %buildroot/etc/%name/dhclient-hooks.d
cp -a dhclient-hooks/* %buildroot/etc/%name/dhclient-hooks.d
chmod 644 %buildroot/etc/%name/dhclient-hooks.d/*

# docs
%define docdir %_docdir/%srcname
rm -rf %buildroot%docdir
mkdir -p %buildroot%docdir
cp -a LICENSE README RELNOTES update_dhcp.pl doc \
	%buildroot%docdir/

# }}}

# {{{ scripts

%pre common
%_sbindir/groupadd -r -f %name

%pre client
rm -f /var/run/dhclient.restart
if [ $1 -ge 2 ] && /sbin/start-stop-daemon --stop --test --exec /sbin/dhclient --pidfile /var/run/dhclient.pid --user root >/dev/null 2>&1; then
	touch /var/run/dhclient.restart
fi

# relocate dhcp.d
if [ ! -d /etc/%name/dhclient.d -a -d /etc/%name/dhcp.d ]; then
	mv -v /etc/%name/dhcp.d /etc/%name/dhclient.d
fi

# relocate dhclient.leases
if [ ! -f %ROOT/dhclient/state/dhclient.leases -a -f %ROOT/dhclient.leases ]; then
	mkdir -p %ROOT/dhclient/state
	cp -pv %ROOT/dhclient.leases %ROOT/dhclient/state/
fi

%post client
if [ -f /var/run/dhclient.restart ]; then
	rm -f /var/run/dhclient.restart
	echo 'Please restart the ISC DHCP client daemon manually.'
fi

%pre server
%_sbindir/useradd -r -N -g %name -d %ROOT/dhcpd -s /dev/null -c 'The ISC DHCP server daemon' dhcpd >/dev/null 2>&1 ||:
%_sbindir/useradd -r -N -g %name -d %ROOT/dhcpd6 -s /dev/null -c 'The ISC DHCPv6 server daemon' dhcpd6 >/dev/null 2>&1 ||:
rm -f /var/run/dhcpd.restart
# stop _old_ dhcpd if running
if [ $1 -eq 1 ] && [ -x %_initdir/dhcpd ] && %_initdir/dhcpd status >/dev/null 2>&1; then
	%_initdir/dhcpd condstop && touch /var/run/dhcpd.restart ||:
fi

# relocate dhcpd.conf
if [ ! -f /etc/%name/dhcpd.conf -a -f /etc/dhcpd.conf ]; then
	mkdir -p /etc/%name
	mv -v /etc/dhcpd.conf /etc/%name/
fi

# relocate dhcpd.leases
if [ ! -f %ROOT/dhcpd/state/dhcpd.leases -a -f %ROOT/dhcpd.leases ]; then
	mkdir -p %ROOT/dhcpd/state
	mv -v %ROOT/dhcpd.leases %ROOT/dhcpd/state/
fi

if [ $1 = 0 ]; then
	rm -f %ROOT/dhcpd/%_lib/* %ROOT/dhcpd/var/yp/binding/*
fi

%post server
%post_service dhcpd
%post_service dhcpd6
if [ -f /var/run/dhcpd.restart ]; then
	rm -f /var/run/dhcpd.restart
	%_initdir/dhcpd start ||:
fi

%preun server
%preun_service dhcpd
%preun_service dhcpd6

%triggerpostun -- %name
[ $1 = 0 ] || exit 0
/sbin/chkconfig --add dhcpd

%pre relay
%_sbindir/useradd -r -N -g %name -d /var/empty -s /dev/null -c 'The ISC DHCP relay daemon' dhcrelay >/dev/null 2>&1 ||:
%_sbindir/useradd -r -N -g %name -d /var/empty -s /dev/null -c 'The ISC DHCPv6 relay daemon' dhcrelay6 >/dev/null 2>&1 ||:
rm -f /var/run/dhcrelay.restart
if [ $1 -ge 2 ] && [ -x %_initdir/dhcrelay ] && %_initdir/dhcrelay status >/dev/null 2>&1; then
	%_initdir/dhcrelay condstop && touch /var/run/dhcrelay.restart ||:
fi

%post relay
if [ -f /var/run/dhcrelay.restart ]; then
	rm -f /var/run/dhcrelay.restart
	%_initdir/dhcrelay start ||:
else
	%post_service dhcrelay
fi
%post_service dhcrelay6

%preun relay
%preun_service dhcrelay
%preun_service dhcrelay6

# }}}

# {{{ files

%files common
%dir %ROOT
%dir /etc/%name
%dir %docdir
%docdir/[A-Z]*
%docdir/doc

%exclude %docdir/doc/ja_JP.eucJP

%files client
%doc /etc/%name/dhclient.*.example
%config(noreplace) /etc/%name/dhclient.conf
%config(noreplace) %_sysconfdir/sysconfig/dhclient
%_sysconfdir/%name/dhclient-hooks.d
%attr(755,root,dhcp) /etc/%name/dhclient-script
%attr(750,root,dhcp) /sbin/dhclient*
%attr(750,root,dhcp) %_sbindir/dhclient*
%_man5dir/dhclient.*
%_man8dir/dhclient*
%attr(700,root,dhcp) %dir %ROOT/dhclient
%attr(700,root,dhcp) %dir %ROOT/dhclient/state
%attr(644,root,dhcp) %config(noreplace) %verify(not md5 mtime size) %ROOT/dhclient/state/dhclient.leases

%files server
/etc/syslog.d/*
%config /etc/chroot.d/dhcpd.*
%config /etc/chroot.d/dhcpd6.*
%config %_initdir/dhcpd
%config %_initdir/dhcpd6
%systemd_unitdir/dhcpd.service
%systemd_unitdir/dhcpd6.service
%config(noreplace) /etc/sysconfig/dhcpd
%config(noreplace) /etc/sysconfig/dhcpd6
%attr(750,root,dhcp) %_sbindir/dhcpd
%attr(0755,root,root) %config(noreplace) %_controldir/dhcpd-chroot
%attr(0755,root,root) %config(noreplace) %_controldir/dhcpd6-chroot
%_man5dir/dhcpd.*
%_man5dir/dhcp-options.*
%_man5dir/dhcp-eval.*
%_man8dir/dhcpd.*
# IPv4 chroot
%attr(0750,root,dhcp) %dir %ROOT/dhcpd
%attr(1770,root,dhcp) %dir %ROOT/dhcpd/state
%attr(0644,dhcpd,dhcp) %config(noreplace) %verify(not md5 mtime size) %ROOT/dhcpd/state/dhcpd.leases
%dir %attr(0710,root,dhcp) %ROOT/dhcpd/dev
%ghost %attr(666,root,root) %ROOT/dhcpd/dev/*
#IPv6 chroot
%attr(0750,root,dhcp) %dir %ROOT/dhcpd6
%attr(1770,root,dhcp) %dir %ROOT/dhcpd6/state
%attr(0644,dhcpd6,dhcp) %config(noreplace) %verify(not md5 mtime size) %ROOT/dhcpd6/state/dhcpd6.leases
%dir %attr(0710,root,dhcp) %ROOT/dhcpd6/dev
%ghost %attr(666,root,root) %ROOT/dhcpd6/dev/*

# Resolver infrastructure
# IPv4
%dir %ROOT/dhcpd/%_lib
%dir %ROOT/dhcpd/etc
%ghost %verify(not md5 mtime size) %ROOT/dhcpd/etc/*
%dir %ROOT/dhcpd/var
%dir %ROOT/dhcpd/var/nis
%ghost %config(missingok) %verify(not md5 mtime size) %ROOT/dhcpd/var/nis/NIS_COLD_START
%dir %ROOT/dhcpd/var/yp
%dir %ROOT/dhcpd/var/yp/binding
# IPv6
%dir %ROOT/dhcpd6/%_lib
%dir %ROOT/dhcpd6/etc
%ghost %verify(not md5 mtime size) %ROOT/dhcpd6/etc/*
%dir %ROOT/dhcpd6/var
%dir %ROOT/dhcpd6/var/nis
%ghost %config(missingok) %verify(not md5 mtime size) %ROOT/dhcpd6/var/nis/NIS_COLD_START
%dir %ROOT/dhcpd6/var/yp
%dir %ROOT/dhcpd6/var/yp/binding

%dir /etc/%name
%doc /etc/%name/dhcpd.*.example
%doc /etc/%name/dhcpd.conf.sample
%doc /etc/%name/dhcpd6.conf.sample
%dir %docdir
%docdir/update_dhcp.pl

%files relay
%config %_initdir/dhcrelay
%systemd_unitdir/dhcrelay.service
%config(noreplace) /etc/sysconfig/dhcrelay
%config %_initdir/dhcrelay6
%systemd_unitdir/dhcrelay6.service
%config(noreplace) /etc/sysconfig/dhcrelay6
%attr(750,root,dhcp) %_sbindir/dhcrelay
%attr(750,root,dhcp) %_sbindir/dhcrelay6
%_man8dir/dhcrelay.*

%files omshell
%_bindir/omshell
%_man1dir/omshell.*
  
%files devel
%_includedir/*
%_libdir/libdhcpctl.so
%_libdir/libomapi.so
%_man3dir/*

%files libs
%_libdir/libdhcpctl.so.*
%_libdir/libomapi.so.*

# }}}

%changelog
